/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

import anon.anonudp.exception.SymmetricKeyCreationFailed;
import anon.anonudp.mixmessage.crypto.BlindingFactor;
import anon.anonudp.mixmessage.crypto.EccGroup713;
import anon.anonudp.mixmessage.crypto.PublicKey;
import java.math.BigInteger;
import java.security.SecureRandom;

public class PrivateKey {
    private final BigInteger underlyingValue;
    private static final SecureRandom random = new SecureRandom();

    public PrivateKey() {
        BigInteger randomNumber;
        while ((randomNumber = new BigInteger(EccGroup713.getOrder().bitLength(), random)).compareTo(EccGroup713.getOrder()) >= 0) {
        }
        this.underlyingValue = randomNumber;
    }

    private PrivateKey(BigInteger bigInteger) {
        this.underlyingValue = bigInteger;
    }

    BigInteger getUnderlyingValue() {
        return this.underlyingValue;
    }

    public PrivateKey blind(PublicKey disposableKey) throws SymmetricKeyCreationFailed {
        BlindingFactor blindingFactor = new BlindingFactor(disposableKey);
        BigInteger newValue = this.underlyingValue.multiply(blindingFactor.getUnderlyingValue());
        return new PrivateKey(newValue);
    }
}

