/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.BasicTrustModel;
import anon.error.ServiceSignatureException;
import anon.error.TrustException;
import anon.infoservice.Database;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.PerformanceEntry;
import anon.infoservice.PerformanceInfo;
import anon.infoservice.ServiceOperator;
import anon.infoservice.StatusInfo;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.IXMLEncodable;
import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrustModel
extends BasicTrustModel
implements IXMLEncodable {
    public static final Integer NOTIFY_TRUST_MODEL_CHANGED = new Integer(0);
    public static final Integer NOTIFY_TRUST_MODEL_ADDED = new Integer(1);
    public static final Integer NOTIFY_TRUST_MODEL_REMOVED = new Integer(2);
    public static final int FIRST_UNRESERVED_MODEL_ID = 5;
    public static final String XML_ELEMENT_NAME = "TrustModel";
    public static final String XML_ELEMENT_CONTAINER_NAME = "TrustModels";
    private static final String XML_ATTR_CURRENT_TRUST_MODEL = "currentTrustModel";
    private static final String XML_ATTR_NAME = "name";
    public static final int TRUST_MODEL_DEFAULT_INDEX = 0;
    public static final TrustModel TRUST_MODEL_ALL_SERVICES;
    private static TrustModel TRUST_MODEL_CUSTOM_FILTER;
    private static MixCascade ms_cascadeWhitelisted;
    public static final int TRUST_ALWAYS = 0;
    public static final int TRUST_IF_NOT_TRUE = 1;
    public static final int TRUST_IF_TRUE = 2;
    public static final int TRUST_IF_AT_LEAST = 3;
    public static final int TRUST_IF_AT_MOST = 5;
    public static final int TRUST_IF_NOT_IN_LIST = 6;
    public static final int TRUST_RESERVED = 7;
    private static final String MSG_SERVICES_WITH_COSTS;
    public static final String MSG_SERVICES_WITHOUT_COSTS;
    private static final String MSG_SERVICES_USER_DEFINED;
    private static final String MSG_CASCADES_FILTER;
    private static final String MSG_ALL_SERVICES;
    private static final String MSG_DEFAULT_FILTER;
    private static final String MSG_SERVICES_BUSINESS;
    private static final String MSG_SERVICES_TEST;
    private static final String MSG_SERVICES_PREMIUM_PRIVATE;
    public static final String MSG_PI_UNAVAILABLE;
    public static final String MSG_BLACKLISTED;
    private static final String MSG_EXCEPTION_NO_SOCKS;
    private static final String MSG_EXCEPTION_DATA_RETENTION;
    private static final String MSG_EXCEPTION_PAY_CASCADE;
    public static final String MSG_EXCEPTION_FREE_CASCADE;
    private static final String MSG_EXCEPTION_WRONG_SERVICE_CONTEXT;
    public static final String MSG_EXCEPTION_NOT_ENOUGH_MIXES;
    public static final String MSG_EXCEPTION_TOO_MANY_MIXES;
    private static final String MSG_EXCEPTION_EXPIRED_CERT;
    private static final String MSG_EXCEPTION_NOT_USER_DEFINED;
    private static final String MSG_EXCEPTION_TOO_FEW_COUNTRIES;
    private static final String MSG_EXCEPTION_TOO_MANY_COUNTRIES;
    private static final String MSG_EXCEPTION_NOT_INTERNATIONAL;
    private static final String MSG_EXCEPTION_INTERNATIONAL;
    private static final String MSG_EXCEPTION_NOT_ENOUGH_ANON;
    private static final String MSG_EXCEPTION_BLACKLISTED;
    private static final String MSG_EXCEPTION_NOT_ENOUGH_SPEED;
    private static final String MSG_EXCEPTION_RESPONSE_TIME_TOO_HIGH;
    private static Vector ms_trustModels;
    private static TrustModel ms_currentTrustModel;
    private static String ms_strContext;
    private static boolean ms_bFreeAllowed;
    private static InnerObservable ms_trustModelObservable;
    private Hashtable m_trustAttributes = new Hashtable();
    private String m_strName;
    private long m_id;
    private boolean m_bEditable;
    static /* synthetic */ Class class$anon$client$TrustModel;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;
    static /* synthetic */ Class class$anon$infoservice$StatusInfo;
    static /* synthetic */ Class class$anon$infoservice$PerformanceInfo;
    static /* synthetic */ Class class$anon$client$TrustModel$ContextAttribute;
    static /* synthetic */ Class class$anon$client$TrustModel$NumberOfMixesAttribute;
    static /* synthetic */ Class class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$client$TrustModel$UsePremiumAttribute;
    static /* synthetic */ Class class$anon$infoservice$BlacklistedCascadeIDEntry;

    private static int getIntegerConditionValue(Object a_conditionValue) {
        if (a_conditionValue == null || !(a_conditionValue instanceof Integer)) {
            return 0;
        }
        return (Integer)a_conditionValue;
    }

    public static String getContext() {
        return ms_strContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateContext(String a_context) {
        Vector vector = ms_trustModels;
        synchronized (vector) {
            boolean bChanged = false;
            if (!(ms_strContext == a_context || a_context == null || ms_strContext != null && ms_strContext.equals(a_context))) {
                if (ms_strContext == null && !a_context.equals("jondonym") || ms_strContext != null) {
                    bChanged = true;
                }
                ms_strContext = a_context;
            }
            if (!bChanged) {
                return false;
            }
            TrustModel temp = ms_currentTrustModel;
            ms_trustModelObservable.setChanged();
            TrustModel.setCurrentTrustModel(temp.getId());
            return true;
        }
    }

    public TrustModel(String a_strName, long a_id) {
        this(a_strName, a_id, false);
        this.setEditable(true);
    }

    private TrustModel(String a_strName, long a_id, boolean b_allowReservedID) {
        if (!b_allowReservedID && a_id < 5L) {
            throw new IllegalArgumentException("Trust model ID " + a_id + " is reserved!");
        }
        this.m_id = a_id;
        this.m_strName = a_strName == null ? "Default trust model" : a_strName;
    }

    public TrustModel(TrustModel a_trustModel) {
        this.setEditable(true);
        this.clone(a_trustModel);
        if (!a_trustModel.isEditable()) {
            this.setEditable(false);
        }
    }

    public TrustModel(Element a_trustModelElement) throws XMLParseException {
        XMLUtil.assertNodeName(a_trustModelElement, XML_ELEMENT_NAME);
        XMLUtil.assertNotNull(a_trustModelElement, "id");
        this.m_id = XMLUtil.parseAttribute((Node)a_trustModelElement, "id", -1L);
        if (this.m_id != 5L) {
            this.m_id = 5L;
        }
        this.m_strName = JAPMessages.getString(MSG_DEFAULT_FILTER);
        this.m_bEditable = true;
        for (int i = 0; i < a_trustModelElement.getChildNodes().getLength(); ++i) {
            Element el = (Element)a_trustModelElement.getChildNodes().item(i);
            try {
                this.setAttribute(TrustAttribute.fromXmlElement(el));
                continue;
            }
            catch (XMLParseException a_e) {
                LogHolder.log(3, LogType.MISC, a_e);
            }
        }
        this.getAttribute(class$anon$client$TrustModel$NumberOfMixesAttribute == null ? (class$anon$client$TrustModel$NumberOfMixesAttribute = TrustModel.class$("anon.client.TrustModel$NumberOfMixesAttribute")) : class$anon$client$TrustModel$NumberOfMixesAttribute);
        this.getAttribute(class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute == null ? (class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute = TrustModel.class$("anon.client.TrustModel$ForcePremiumIfChargedAccountAttribute")) : class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockInterfacesFromDatabase() {
        ListenerInterface.unblockInterfacesFromDatabase(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = TrustModel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade);
        Vector vector = ms_trustModels;
        synchronized (vector) {
            ms_trustModelObservable.setChanged();
            ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAttributes(TrustModel a_trustModel) {
        if (a_trustModel == null) {
            throw new NullPointerException("No argument given!");
        }
        if (!this.isEditable()) {
            throw new IllegalStateException("Trust model not editable!");
        }
        Cloneable cloneable = this.m_trustAttributes;
        synchronized (cloneable) {
            this.m_trustAttributes = (Hashtable)a_trustModel.m_trustAttributes.clone();
        }
        cloneable = ms_trustModels;
        synchronized (cloneable) {
            if (ms_trustModels.contains(this)) {
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
            }
        }
    }

    public void clone(TrustModel a_trustModel) {
        if (a_trustModel == null) {
            throw new NullPointerException("No argument given!");
        }
        if (!this.isEditable()) {
            throw new IllegalStateException("Trust model not editable!");
        }
        this.m_id = a_trustModel.m_id;
        this.m_strName = a_trustModel.m_strName;
        this.copyAttributes(a_trustModel);
        this.m_bEditable = a_trustModel.m_bEditable;
    }

    public static Observable getObservable() {
        return ms_trustModelObservable;
    }

    public static void addModelObserver(Observer a_observer) {
        ms_trustModelObservable.addObserver(a_observer);
    }

    public static void deleteModelObserver(Observer a_observer) {
        ms_trustModelObservable.deleteObserver(a_observer);
    }

    public boolean equals(Object a_trustModel) {
        if (a_trustModel == null || !(a_trustModel instanceof TrustModel)) {
            return false;
        }
        return this.getId() == ((TrustModel)a_trustModel).getId();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public static void setFreeAllowed(boolean a_bFreeAllowed) {
        ms_bFreeAllowed = a_bFreeAllowed;
    }

    public static boolean isFreeAllowed() {
        return ms_bFreeAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowAttributeWhitelist(MixCascade a_cascade) {
        Vector vector = ms_trustModels;
        synchronized (vector) {
            if (!(a_cascade == null || ms_cascadeWhitelisted != null && ms_cascadeWhitelisted.getId().equals(a_cascade))) {
                ms_cascadeWhitelisted = a_cascade;
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanAttributeWhitelist(MixCascade a_currentCascade) {
        Vector vector = ms_trustModels;
        synchronized (vector) {
            if (a_currentCascade == null || ms_cascadeWhitelisted != null && !ms_cascadeWhitelisted.getId().equals(a_currentCascade.getId())) {
                ms_cascadeWhitelisted = null;
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addTrustModel(TrustModel a_trustModel) {
        Vector vector = ms_trustModels;
        synchronized (vector) {
            if (a_trustModel != null && !ms_trustModels.contains(a_trustModel)) {
                if (a_trustModel.getId() == 5L) {
                    TRUST_MODEL_CUSTOM_FILTER = a_trustModel;
                }
                if (ms_currentTrustModel != null && ms_currentTrustModel.getId() == a_trustModel.getId()) {
                    ms_currentTrustModel = a_trustModel;
                }
                ms_trustModels.insertElementAt(a_trustModel, 0);
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_ADDED);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrustModel removeTrustModel(TrustModel a_trustModel) {
        if (a_trustModel == null) {
            return null;
        }
        if (!a_trustModel.isEditable()) {
            return null;
        }
        Vector vector = ms_trustModels;
        synchronized (vector) {
            if (a_trustModel != null && ms_trustModels.removeElement(a_trustModel)) {
                if (TrustModel.getCurrentTrustModel() == a_trustModel) {
                    TrustModel.restoreDefault();
                }
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_REMOVED);
                return a_trustModel;
            }
        }
        return null;
    }

    public TrustAttribute setAttribute(Class a_attr, int a_trustCondition) {
        return this.setAttribute(a_attr, a_trustCondition, false);
    }

    private TrustAttribute setAttribute(Class a_attr, int a_trustCondition, boolean a_bIgnoreNoDataAvailable) {
        return this.setAttribute(a_attr, a_trustCondition, null, a_bIgnoreNoDataAvailable);
    }

    public TrustAttribute setAttribute(Class a_attr, int a_trustCondition, int a_conditionValue) {
        return this.setAttribute(a_attr, a_trustCondition, a_conditionValue, false);
    }

    public TrustAttribute setAttribute(Class a_attr, int a_trustCondition, Object a_conditionValue) {
        return this.setAttribute(a_attr, a_trustCondition, a_conditionValue, false);
    }

    private TrustAttribute setAttribute(Class a_attr, int a_trustCondition, int a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
        return this.setAttribute(a_attr, a_trustCondition, new Integer(a_conditionValue), a_bIgnoreNoDataAvailable);
    }

    public TrustAttribute setAttribute(Class a_attr, int a_trustCondition, Vector a_conditionValue) {
        return this.setAttribute(a_attr, a_trustCondition, a_conditionValue, false);
    }

    private void setEditable(boolean a_bEditable) {
        this.m_bEditable = a_bEditable;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    private TrustAttribute setAttribute(Class a_attr, int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
        return this.setAttribute(TrustAttribute.getInstance(a_attr, a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAttributes() {
        if (!this.isEditable()) {
            throw new IllegalStateException("Trust model not editable!");
        }
        Hashtable hashtable = this.m_trustAttributes;
        synchronized (hashtable) {
            if (this.m_trustAttributes.size() > 0) {
                ms_trustModelObservable.setChanged();
                this.m_trustAttributes.clear();
            }
        }
        ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustAttribute setAttribute(TrustAttribute a_attr) {
        if (a_attr != null) {
            Vector vector = ms_trustModels;
            synchronized (vector) {
                Hashtable hashtable = this.m_trustAttributes;
                synchronized (hashtable) {
                    TrustAttribute value = (TrustAttribute)this.m_trustAttributes.get(a_attr);
                    if (value != null && (value.getTrustCondition() != a_attr.getTrustCondition() || value.getConditionValue() != a_attr.getConditionValue())) {
                        this.m_trustAttributes.put(a_attr, value);
                        if (ms_trustModels.contains(this)) {
                            ms_trustModelObservable.setChanged();
                        }
                    }
                    this.m_trustAttributes.put(a_attr.getClass(), a_attr);
                }
                if (ms_trustModels.contains(this)) {
                    ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
                }
            }
        }
        return a_attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustAttribute getAttribute(Class a_attr) {
        if (a_attr == null) {
            return null;
        }
        Hashtable hashtable = this.m_trustAttributes;
        synchronized (hashtable) {
            TrustAttribute attr = (TrustAttribute)this.m_trustAttributes.get(a_attr);
            if (attr == null) {
                Object defaultValue = new Integer(0);
                int iDefaultCondition = 0;
                try {
                    Method getDefaultValue = a_attr.getMethod("getDefaultValue", null);
                    defaultValue = getDefaultValue.invoke(null, (Object[])null);
                }
                catch (Exception ex) {
                    LogHolder.log(2, LogType.MISC, "Exception occured while trying to get the default value of a TrustAttribute: ", ex);
                }
                try {
                    Method getDefaultCondition = a_attr.getMethod("getDefaultCondition", null);
                    iDefaultCondition = (Integer)getDefaultCondition.invoke(null, (Object[])null);
                }
                catch (Exception ex) {
                    LogHolder.log(2, LogType.MISC, "Exception occured while trying to get the default value of a TrustAttribute: ", ex);
                }
                return this.setAttribute(a_attr, iDefaultCondition, defaultValue);
            }
            return attr;
        }
    }

    public static Vector getTrustModels() {
        return (Vector)ms_trustModels.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentTrustModel(long a_id) {
        if (a_id < 0L) {
            return;
        }
        Vector vector = ms_trustModels;
        synchronized (vector) {
            for (int i = 0; i < ms_trustModels.size(); ++i) {
                if (((TrustModel)ms_trustModels.elementAt(i)).getId() != a_id) continue;
                ms_currentTrustModel = (TrustModel)ms_trustModels.elementAt(i);
                ms_trustModelObservable.setChanged();
                ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentTrustModel(TrustModel a_trustModel) {
        if (a_trustModel == null) {
            return;
        }
        Vector vector = ms_trustModels;
        synchronized (vector) {
            if (!ms_trustModels.contains(a_trustModel)) {
                ms_trustModels.addElement(a_trustModel);
            }
            if (ms_currentTrustModel != a_trustModel) {
                ms_currentTrustModel = a_trustModel;
                ms_trustModelObservable.setChanged();
            }
            ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
        }
    }

    public static TrustModel getTrustModelDefault() {
        return (TrustModel)ms_trustModels.elementAt(0);
    }

    public static TrustModel getCurrentTrustModel() {
        return ms_currentTrustModel;
    }

    public static TrustModel getCustomFilter() {
        return TRUST_MODEL_CUSTOM_FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromXmlElement(Element a_container) {
        int trustModelsAdded = 0;
        if (a_container != null && a_container.getNodeName().equals(XML_ELEMENT_CONTAINER_NAME)) {
            NodeList elements = a_container.getElementsByTagName(XML_ELEMENT_NAME);
            for (int i = 0; i < elements.getLength(); ++i) {
                Vector vector = ms_trustModels;
                synchronized (vector) {
                    try {
                        TrustModel model = new TrustModel((Element)elements.item(i));
                        boolean bReplaced = false;
                        for (int j = 0; j < ms_trustModels.size(); ++j) {
                            if (((TrustModel)ms_trustModels.elementAt(j)).getId() != model.getId()) continue;
                            if (model.getId() == 5L) {
                                TRUST_MODEL_CUSTOM_FILTER = model;
                            }
                            ms_trustModels.removeElementAt(j);
                            ms_trustModels.insertElementAt(model, j);
                            bReplaced = true;
                            break;
                        }
                        if (model.getId() == ms_currentTrustModel.getId()) {
                            ms_currentTrustModel = model;
                        }
                        if (bReplaced) {
                            ms_trustModelObservable.setChanged();
                            ms_trustModelObservable.notifyObservers(NOTIFY_TRUST_MODEL_CHANGED);
                        } else {
                            TrustModel.addTrustModel(model);
                        }
                        ++trustModelsAdded;
                    }
                    catch (Exception a_e) {
                        LogHolder.log(2, LogType.MISC, "Could not load trust model from XML!", a_e);
                    }
                    continue;
                }
            }
            if (trustModelsAdded == 0) {
                TrustModel.addCustomFilter();
            }
            TrustModel.setCurrentTrustModel(XMLUtil.parseAttribute((Node)a_container, XML_ATTR_CURRENT_TRUST_MODEL, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCustomFilter() {
        Vector vector = ms_trustModels;
        synchronized (vector) {
            TrustModel.removeTrustModel(TRUST_MODEL_CUSTOM_FILTER);
            TrustModel model = new TrustModel(MSG_DEFAULT_FILTER, 5L, false);
            model.setAttribute(class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute == null ? (class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute = TrustModel.class$("anon.client.TrustModel$ForcePremiumIfChargedAccountAttribute")) : class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute, 2);
            model.setEditable(true);
            TrustModel.addTrustModel(model);
        }
    }

    public static void restoreDefault() {
        TrustModel.addCustomFilter();
        TrustModel.setCurrentTrustModel(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element toXmlElement(Document a_doc, String a_xmlContainerName) {
        if (a_doc == null || a_xmlContainerName == null) {
            return null;
        }
        Element container = a_doc.createElement(a_xmlContainerName);
        XMLUtil.setAttribute(container, XML_ATTR_CURRENT_TRUST_MODEL, TrustModel.getCurrentTrustModel().getId());
        Vector vector = ms_trustModels;
        synchronized (vector) {
            for (int i = 0; i < ms_trustModels.size(); ++i) {
                if (!((TrustModel)ms_trustModels.elementAt(i)).isEditable()) continue;
                container.appendChild(((TrustModel)ms_trustModels.elementAt(i)).toXmlElement(a_doc));
            }
        }
        return container;
    }

    public void setName(String a_strName) throws IllegalArgumentException {
        if (a_strName == null || a_strName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid name for trust model!");
        }
        this.m_strName = a_strName.trim().equals(JAPMessages.getString(MSG_CASCADES_FILTER)) ? "" : a_strName;
    }

    public String getName() {
        if (this.m_strName == null || this.m_strName.trim().length() == 0) {
            return JAPMessages.getString(MSG_CASCADES_FILTER);
        }
        return JAPMessages.getString(this.m_strName);
    }

    public String toString() {
        return this.getName();
    }

    public long getId() {
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        if (a_doc == null) {
            return null;
        }
        Element elemTrustModel = a_doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(elemTrustModel, "id", this.m_id);
        Hashtable hashtable = this.m_trustAttributes;
        synchronized (hashtable) {
            Enumeration e = this.m_trustAttributes.elements();
            while (e.hasMoreElements()) {
                TrustAttribute attr = (TrustAttribute)e.nextElement();
                elemTrustModel.appendChild(attr.toXmlElement(a_doc));
            }
        }
        return elemTrustModel;
    }

    public boolean isFreeServicesForced() {
        TrustAttribute attr = this.getAttribute(class$anon$client$TrustModel$UsePremiumAttribute == null ? (class$anon$client$TrustModel$UsePremiumAttribute = TrustModel.class$("anon.client.TrustModel$UsePremiumAttribute")) : class$anon$client$TrustModel$UsePremiumAttribute);
        return attr == null ? false : attr.getTrustCondition() == 1;
    }

    public boolean isPaymentForced() {
        if (!TrustModel.isFreeAllowed()) {
            return true;
        }
        TrustAttribute attr = this.getAttribute(class$anon$client$TrustModel$UsePremiumAttribute == null ? (class$anon$client$TrustModel$UsePremiumAttribute = TrustModel.class$("anon.client.TrustModel$UsePremiumAttribute")) : class$anon$client$TrustModel$UsePremiumAttribute);
        return attr == null ? false : attr.getTrustCondition() == 2;
    }

    public boolean isAdded() {
        return true;
    }

    public int countTrustedCascades() {
        Vector list = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = TrustModel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
        int iTrusted = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isTrusted((MixCascade)list.elementAt(i))) continue;
            ++iTrusted;
        }
        return iTrusted;
    }

    public boolean hasTrustedCascades() {
        Vector list = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = TrustModel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isTrusted((MixCascade)list.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean hasPremiumCascades() {
        Vector list = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = TrustModel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
        for (int i = 0; i < list.size(); ++i) {
            if (!((MixCascade)list.elementAt(i)).isPayment() || !this.isTrusted((MixCascade)list.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean hasFreeCascades() {
        Vector list = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = TrustModel.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
        for (int i = 0; i < list.size(); ++i) {
            if (((MixCascade)list.elementAt(i)).isPayment() || !this.isTrusted((MixCascade)list.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        return Database.getInstance(class$anon$infoservice$BlacklistedCascadeIDEntry == null ? (class$anon$infoservice$BlacklistedCascadeIDEntry = TrustModel.class$("anon.infoservice.BlacklistedCascadeIDEntry")) : class$anon$infoservice$BlacklistedCascadeIDEntry).getEntryById(a_cascade.getMixIDsAsString()) != null;
    }

    public static boolean areListenerInterfacesBlocked(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        return a_cascade.areListenerInterfacesBlocked();
    }

    public static boolean isNoPaymentInstanceFound(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        return a_cascade.isPayment() && PayAccountsFile.getInstance().getBI(a_cascade.getPIID()) == null && PayAccountsFile.getInstance().getChargedAccount(a_cascade.getPIID()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector readUntrustedAttributeText(MixCascade a_cascade) {
        Vector<String> vecReasons = new Vector<String>();
        if (!this.isTrusted(a_cascade)) {
            Hashtable hashtable = this.m_trustAttributes;
            synchronized (hashtable) {
                Enumeration e = this.m_trustAttributes.elements();
                while (e.hasMoreElements()) {
                    TrustAttribute attr = (TrustAttribute)e.nextElement();
                    try {
                        attr.checkTrust(a_cascade);
                    }
                    catch (TrustException e1) {
                        vecReasons.addElement(e1.getMessage());
                    }
                    catch (ServiceSignatureException e1) {
                        vecReasons.addElement(e1.getMessage());
                    }
                }
            }
        }
        return vecReasons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTrust(MixCascade a_cascade, boolean a_bCheckUserDefined) throws TrustException, ServiceSignatureException {
        if (a_cascade == null) {
            throw new TrustException(a_cascade, "Null cascade!");
        }
        if (TrustModel.isBlacklisted(a_cascade)) {
            throw new TrustException(a_cascade, JAPMessages.getString(MSG_BLACKLISTED));
        }
        if (a_bCheckUserDefined || !a_cascade.isUserDefined()) {
            if (!ms_bFreeAllowed && !a_cascade.isPayment()) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_FREE_CASCADE));
            }
            if (TrustModel.isNoPaymentInstanceFound(a_cascade)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_PI_UNAVAILABLE));
            }
            super.checkTrust(a_cascade, a_bCheckUserDefined);
        } else if (a_cascade.getNumberOfOperators() <= 0) {
            return;
        }
        MixCascade cascadeWhitelist = ms_cascadeWhitelisted;
        if (cascadeWhitelist == null || !cascadeWhitelist.getId().equals(a_cascade.getId())) {
            Hashtable hashtable = this.m_trustAttributes;
            synchronized (hashtable) {
                Enumeration e = this.m_trustAttributes.elements();
                while (e.hasMoreElements()) {
                    TrustAttribute attr = (TrustAttribute)e.nextElement();
                    attr.checkTrust(a_cascade);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_cascadeWhitelisted = null;
        MSG_SERVICES_WITH_COSTS = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesWithCosts";
        MSG_SERVICES_WITHOUT_COSTS = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesWithoutCosts";
        MSG_SERVICES_USER_DEFINED = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesUserDefined";
        MSG_CASCADES_FILTER = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesFilter";
        MSG_ALL_SERVICES = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_allServices";
        MSG_DEFAULT_FILTER = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + ".defaultFilter";
        MSG_SERVICES_BUSINESS = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesBusiness";
        MSG_SERVICES_TEST = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesTest";
        MSG_SERVICES_PREMIUM_PRIVATE = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_servicesPremiumPrivate";
        MSG_PI_UNAVAILABLE = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_piUnavailable";
        MSG_BLACKLISTED = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_blacklisted";
        MSG_EXCEPTION_NO_SOCKS = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNoSocks";
        MSG_EXCEPTION_DATA_RETENTION = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionDataRetention";
        MSG_EXCEPTION_PAY_CASCADE = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionPayCascade";
        MSG_EXCEPTION_FREE_CASCADE = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionFreeCascade";
        MSG_EXCEPTION_WRONG_SERVICE_CONTEXT = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_wrongServiceContext";
        MSG_EXCEPTION_NOT_ENOUGH_MIXES = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNotEnoughMixes";
        MSG_EXCEPTION_TOO_MANY_MIXES = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionTooManyMixes";
        MSG_EXCEPTION_EXPIRED_CERT = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionExpiredCert";
        MSG_EXCEPTION_NOT_USER_DEFINED = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNotUserDefined";
        MSG_EXCEPTION_TOO_FEW_COUNTRIES = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionTooFewCountries";
        MSG_EXCEPTION_TOO_MANY_COUNTRIES = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionTooManyCountries";
        MSG_EXCEPTION_NOT_INTERNATIONAL = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNotInternational";
        MSG_EXCEPTION_INTERNATIONAL = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionInternational";
        MSG_EXCEPTION_NOT_ENOUGH_ANON = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNotEnoughAnon";
        MSG_EXCEPTION_BLACKLISTED = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionBlacklisted";
        MSG_EXCEPTION_NOT_ENOUGH_SPEED = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionNotEnoughSpeed";
        MSG_EXCEPTION_RESPONSE_TIME_TOO_HIGH = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + "_exceptionResponseTimeTooHigh";
        ms_trustModels = new Vector();
        ms_strContext = "jondonym";
        ms_bFreeAllowed = true;
        ms_trustModelObservable = new InnerObservable();
        TrustModel model = new TrustModel(MSG_ALL_SERVICES, -1L, true);
        model.setAttribute(class$anon$client$TrustModel$ContextAttribute == null ? (class$anon$client$TrustModel$ContextAttribute = TrustModel.class$("anon.client.TrustModel$ContextAttribute")) : class$anon$client$TrustModel$ContextAttribute, 7);
        TRUST_MODEL_ALL_SERVICES = model;
        TrustModel.addCustomFilter();
        TrustModel.setCurrentTrustModel((TrustModel)ms_trustModels.elementAt(0));
    }

    public static class DelayAttribute
    extends TrustAttribute {
        public DelayAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(5, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException {
            if (Database.getInstance(class$anon$infoservice$PerformanceInfo == null ? (class$anon$infoservice$PerformanceInfo = TrustModel.class$("anon.infoservice.PerformanceInfo")) : class$anon$infoservice$PerformanceInfo).getNumberOfEntries() == 0) {
                return;
            }
            PerformanceEntry entry = PerformanceInfo.getLowestCommonBoundEntry(a_cascade.getId());
            Object conditionValue = this.getConditionValue();
            if (conditionValue == null || TrustModel.getIntegerConditionValue(conditionValue) == Integer.MAX_VALUE) {
                return;
            }
            if (entry == null || entry.getBound(1).getBound() == 0) {
                if (this.isNoDataIgnored()) {
                    return;
                }
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_RESPONSE_TIME_TOO_HIGH));
            }
            if (this.getTrustCondition() == 5 && (entry == null || entry.getBound(1).getBound() < 0 || entry.getBound(1).getBound() > TrustModel.getIntegerConditionValue(conditionValue))) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_RESPONSE_TIME_TOO_HIGH));
            }
        }

        public static Object getDefaultValue() {
            return new Integer(Integer.MAX_VALUE);
        }
    }

    public static class SpeedAttribute
    extends TrustAttribute {
        public SpeedAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(3, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException {
            if (Database.getInstance(class$anon$infoservice$PerformanceInfo == null ? (class$anon$infoservice$PerformanceInfo = TrustModel.class$("anon.infoservice.PerformanceInfo")) : class$anon$infoservice$PerformanceInfo).getNumberOfEntries() == 0) {
                return;
            }
            PerformanceEntry entry = PerformanceInfo.getLowestCommonBoundEntry(a_cascade.getId());
            Object condidtionValue = this.getConditionValue();
            if (condidtionValue == null || TrustModel.getIntegerConditionValue(condidtionValue) <= 0) {
                return;
            }
            if (entry == null || entry.getBound(0).getBound() == Integer.MAX_VALUE) {
                if (this.isNoDataIgnored()) {
                    return;
                }
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_ENOUGH_SPEED));
            }
            if (this.getTrustCondition() == 3 && (entry == null || entry.getBound(0).getBound() < TrustModel.getIntegerConditionValue(condidtionValue))) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_ENOUGH_SPEED));
            }
        }
    }

    public static class OperatorBlacklistAttribute
    extends TrustAttribute {
        public OperatorBlacklistAttribute(int a_trustCondtion, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(6, a_conditionValue == null || !(a_conditionValue instanceof Vector) ? new Vector() : a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            Object conditionValue = this.getConditionValue();
            if (conditionValue == null || !(conditionValue instanceof Vector)) {
                return;
            }
            if (this.getTrustCondition() == 6) {
                for (int i = 0; i < a_cascade.getNumberOfMixes(); ++i) {
                    Vector list = (Vector)conditionValue;
                    MixInfo mixInfo = a_cascade.getMixInfo(i);
                    ServiceOperator mixOperator = null;
                    if (mixInfo != null) {
                        mixOperator = mixInfo.getServiceOperator();
                    }
                    if (mixOperator != null && list.contains(mixOperator)) {
                        throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_BLACKLISTED));
                    }
                    if (mixOperator == null || mixOperator.getOrganization() == null) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        ServiceOperator blacklistedOperator = (ServiceOperator)list.elementAt(j);
                        if (blacklistedOperator.getOrganization() == null || !blacklistedOperator.getOrganization().equals(mixOperator.getOrganization())) continue;
                        throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_BLACKLISTED));
                    }
                }
            }
        }
    }

    public static class AnonLevelAttribute
    extends TrustAttribute {
        public AnonLevelAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(3, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            Object conditionValue = this.getConditionValue();
            StatusInfo info = (StatusInfo)Database.getInstance(class$anon$infoservice$StatusInfo == null ? (class$anon$infoservice$StatusInfo = TrustModel.class$("anon.infoservice.StatusInfo")) : class$anon$infoservice$StatusInfo).getEntryById(a_cascade.getId());
            if (this.getTrustCondition() == 3 && (info == null || conditionValue != null && info.getAnonLevel() < TrustModel.getIntegerConditionValue(conditionValue))) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_ENOUGH_ANON));
            }
        }
    }

    public static class InternationalAttribute
    extends TrustAttribute {
        public InternationalAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            Object conditionValue = this.getConditionValue();
            if (conditionValue == null) {
                return;
            }
            if (this.getTrustCondition() == 3 && a_cascade.getNumberOfCountries() < TrustModel.getIntegerConditionValue(conditionValue)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_TOO_FEW_COUNTRIES) + ": " + a_cascade.getNumberOfCountries());
            }
            if (this.getTrustCondition() == 5 && a_cascade.getNumberOfCountries() > TrustModel.getIntegerConditionValue(conditionValue)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_TOO_MANY_COUNTRIES) + ": " + a_cascade.getNumberOfCountries());
            }
        }
    }

    public static class UserDefinedAttribute
    extends TrustAttribute {
        public UserDefinedAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (this.getTrustCondition() == 2) {
                if (a_cascade.isUserDefined()) {
                    return;
                }
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_USER_DEFINED));
            }
        }
    }

    public static class NumberOfMixesAttribute
    extends TrustAttribute {
        public NumberOfMixesAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public static int getDefaultCondition() {
            return 0;
        }

        public static Object getDefaultValue() {
            return new Integer(1);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            Object conditionValue = this.getConditionValue();
            if (conditionValue == null) {
                return;
            }
            int minMixes = TrustModel.getIntegerConditionValue(conditionValue);
            if (this.getTrustCondition() == 3 && (a_cascade == null || a_cascade.getNumberOfOperators() < minMixes)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_ENOUGH_MIXES) + ": " + a_cascade.getNumberOfOperators());
            }
            if (this.getTrustCondition() == 5 && a_cascade != null && a_cascade.getNumberOfOperators() > minMixes) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_TOO_MANY_MIXES) + ": " + a_cascade.getNumberOfOperators());
            }
        }
    }

    public static class SocksAttribute
    extends TrustAttribute {
        public SocksAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (!a_cascade.isSocks5Supported() && this.getTrustCondition() == 2) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NO_SOCKS));
            }
        }
    }

    public static class DataRetentionAttribute
    extends TrustAttribute {
        public DataRetentionAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (a_cascade.getDataRetentionInformation() != null && this.getTrustCondition() == 1) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_DATA_RETENTION));
            }
        }
    }

    public static class UsePremiumAttribute
    extends TrustAttribute {
        public UsePremiumAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (a_cascade.isPayment()) {
                if (this.getTrustCondition() == 1) {
                    throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_PAY_CASCADE));
                }
            } else if (this.getTrustCondition() == 2) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_FREE_CASCADE));
            }
        }
    }

    public static class PremiumChargedAccountAttribute
    extends TrustAttribute {
        public PremiumChargedAccountAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (this.getTrustCondition() != 0 && a_cascade.isPayment() && PayAccountsFile.getInstance().getChargedAccount(a_cascade.getPIID()) == null) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_PAY_CASCADE));
            }
        }
    }

    public static class ForcePremiumIfChargedAccountAttribute
    extends TrustAttribute {
        public ForcePremiumIfChargedAccountAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public static int getDefaultCondition() {
            return 2;
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (this.getTrustCondition() == 2 && !a_cascade.isPayment() && !a_cascade.isPayment()) {
                Vector vecEntries = Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = TrustModel.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryList();
                for (int i = 0; i < vecEntries.size(); ++i) {
                    PaymentInstanceDBEntry entry = (PaymentInstanceDBEntry)vecEntries.elementAt(i);
                    if (entry.isTest() || PayAccountsFile.getInstance().getChargedAccount(entry.getId()) == null) continue;
                    throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_FREE_CASCADE));
                }
            }
        }
    }

    public static class ForcePremiumIfExistingUserAttribute
    extends TrustAttribute {
        public ForcePremiumIfExistingUserAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public static int getDefaultCondition() {
            return 0;
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            if (this.getTrustCondition() == 2) {
                if (a_cascade.isPayment()) {
                    if (a_cascade.getNumberOfOperators() < 2) {
                        throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NOT_ENOUGH_MIXES) + ": " + a_cascade.getNumberOfOperators());
                    }
                    if (!a_cascade.isSocks5Supported()) {
                        throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_NO_SOCKS));
                    }
                } else if (!a_cascade.isPayment() && !PayAccountsFile.getInstance().isNewUser()) {
                    throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_FREE_CASCADE));
                }
            }
        }
    }

    public static class ContextAttribute
    extends TrustAttribute {
        public ContextAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            super(a_trustCondition, a_conditionValue, a_bIgnoreNoDataAvailable);
        }

        public void checkTrust(MixCascade a_cascade) throws TrustException, ServiceSignatureException {
            String strContextCascade = a_cascade.getContext();
            String strContextModel = ms_strContext;
            if (this.getTrustCondition() == 2 && !strContextCascade.equals(strContextModel)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_WRONG_SERVICE_CONTEXT));
            }
            if (this.getTrustCondition() == 1 && strContextCascade.equals(strContextModel)) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_WRONG_SERVICE_CONTEXT));
            }
            if (!(strContextCascade.equals(strContextModel) || strContextModel.startsWith("jondonym") && strContextCascade.equals("jondonym.premium"))) {
                throw new TrustException(a_cascade, JAPMessages.getString(MSG_EXCEPTION_WRONG_SERVICE_CONTEXT));
            }
        }
    }

    public static abstract class TrustAttribute
    implements IXMLEncodable {
        public static final int CATEGORY_DEFAULT = 0;
        public static final String XML_ELEMENT_NAME = "TrustAttribute";
        public static final String XML_VALUE_ELEMENT_NAME = "ConditionValue";
        public static final String XML_VALUE_CONTAINER_ELEMENT_NAME = "ConditionValueList";
        public static final String XML_ATTR_NAME = "name";
        public static final String XML_ATTR_TRUST_CONDITION = "trustCondition";
        public static final String XML_ATTR_CONDITION_VALUE = "conditonValue";
        public static final String XML_ATTR_IGNORE_NO_DATA = "ignoreNoData";
        private int m_category;
        private boolean m_bIgnoreNoDataAvailable;
        private int m_trustCondition;
        private Object m_conditionValue;

        protected TrustAttribute(int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            this.m_trustCondition = a_trustCondition;
            this.m_conditionValue = a_conditionValue;
            this.m_category = 0;
            this.m_bIgnoreNoDataAvailable = a_bIgnoreNoDataAvailable;
        }

        public static int getDefaultCondition() {
            return 0;
        }

        public static Object getDefaultValue() {
            return new Integer(0);
        }

        public boolean isNoDataIgnored() {
            return this.m_bIgnoreNoDataAvailable;
        }

        public final int getCategory() {
            return this.m_category;
        }

        public int getTrustCondition() {
            return this.m_trustCondition;
        }

        public Object getConditionValue() {
            return this.m_conditionValue;
        }

        public boolean isTrusted(MixCascade a_cascade) {
            try {
                this.checkTrust(a_cascade);
                return true;
            }
            catch (TrustException a_e) {
            }
            catch (ServiceSignatureException serviceSignatureException) {
                // empty catch block
            }
            return false;
        }

        public abstract void checkTrust(MixCascade var1) throws TrustException, ServiceSignatureException;

        public Element toXmlElement(Document a_doc) {
            if (a_doc == null) {
                return null;
            }
            Element el = a_doc.createElement(XML_ELEMENT_NAME);
            XMLUtil.setAttribute(el, "name", this.getClass().getName());
            XMLUtil.setAttribute(el, XML_ATTR_TRUST_CONDITION, this.m_trustCondition);
            XMLUtil.setAttribute(el, XML_ATTR_IGNORE_NO_DATA, this.m_bIgnoreNoDataAvailable);
            if (this.m_conditionValue instanceof Integer) {
                XMLUtil.setAttribute(el, XML_ATTR_CONDITION_VALUE, (Integer)this.m_conditionValue);
            } else if (this.m_conditionValue instanceof Vector) {
                Vector vec = (Vector)this.m_conditionValue;
                Element list = a_doc.createElement(XML_VALUE_CONTAINER_ELEMENT_NAME);
                for (int i = 0; i < vec.size(); ++i) {
                    Element e = a_doc.createElement(XML_VALUE_ELEMENT_NAME);
                    XMLUtil.setValue((Node)e, ((ServiceOperator)vec.elementAt(i)).getId());
                    list.appendChild(e);
                }
                el.appendChild(list);
            }
            return el;
        }

        public static TrustAttribute fromXmlElement(Element a_e) throws XMLParseException {
            TrustAttribute attr;
            if (a_e == null) {
                return null;
            }
            XMLUtil.assertNodeName(a_e, XML_ELEMENT_NAME);
            XMLUtil.assertNotNull(a_e, "name");
            String name = XMLUtil.parseAttribute((Node)a_e, "name", null);
            int trustCondition = XMLUtil.parseAttribute((Node)a_e, XML_ATTR_TRUST_CONDITION, 0);
            int conditionValue = XMLUtil.parseAttribute((Node)a_e, XML_ATTR_CONDITION_VALUE, 0);
            boolean bIgnoreNoData = XMLUtil.parseAttribute((Node)a_e, XML_ATTR_IGNORE_NO_DATA, false);
            try {
                Serializable value = null;
                if (trustCondition == 6) {
                    Node n = XMLUtil.getFirstChildByName(a_e, XML_VALUE_CONTAINER_ELEMENT_NAME);
                    XMLUtil.assertNotNull(n);
                    NodeList list = n.getChildNodes();
                    value = new Vector();
                    for (int i = 0; i < list.getLength(); ++i) {
                        ServiceOperator op = (ServiceOperator)Database.getInstance(class$anon$infoservice$ServiceOperator == null ? TrustModel.class$("anon.infoservice.ServiceOperator") : class$anon$infoservice$ServiceOperator).getEntryById(XMLUtil.parseValue(list.item(i), null));
                        if (op == null) continue;
                        ((Vector)value).addElement(op);
                    }
                } else {
                    value = new Integer(conditionValue);
                }
                if (name != null && name.startsWith("jap.TrustModel")) {
                    name = (class$anon$client$TrustModel == null ? (class$anon$client$TrustModel = TrustModel.class$("anon.client.TrustModel")) : class$anon$client$TrustModel).getName() + name.substring("jap.TrustModel".length(), name.length());
                }
                if ((attr = TrustAttribute.getInstance(Class.forName(name), trustCondition, value, bIgnoreNoData)) == null) {
                    throw new XMLParseException(XML_ELEMENT_NAME, "Could not create TrustAttribute + " + name + "!");
                }
            }
            catch (Exception ex) {
                LogHolder.log(5, LogType.DB, ex);
                throw new XMLParseException(XML_ELEMENT_NAME, ex.getMessage());
            }
            return attr;
        }

        public static TrustAttribute getInstance(Class a_attr, int a_trustCondition, Object a_conditionValue, boolean a_bIgnoreNoDataAvailable) {
            try {
                return (TrustAttribute)a_attr.getConstructor(Integer.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = TrustModel.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE).newInstance(new Integer(a_trustCondition), a_conditionValue, new Boolean(a_bIgnoreNoDataAvailable));
            }
            catch (Exception ex) {
                LogHolder.log(2, LogType.MISC, "Could not create " + a_attr);
                return null;
            }
        }
    }

    public static class InnerObservable
    extends Observable {
        public void setChanged() {
            super.setChanged();
        }
    }
}

