/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertificateRevocationList;
import anon.crypto.JAPCertificate;
import anon.crypto.RevokedCertificate;
import anon.crypto.X509DistinguishedName;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public class RevokedCertifcateStore {
    private static RevokedCertifcateStore m_instance;
    private static final String CRL_PATH = "crls/";
    private Hashtable m_revokedCerts;
    static /* synthetic */ Class class$anon$crypto$RevokedCertifcateStore;

    private RevokedCertifcateStore() {
        CertificateRevocationList crl = null;
        this.m_revokedCerts = new Hashtable();
        Enumeration crls = CertificateRevocationList.getInstance(CRL_PATH, true, null).elements();
        while (crls.hasMoreElements()) {
            crl = (CertificateRevocationList)crls.nextElement();
            this.addRevocations(crl);
        }
        if (crl == null) {
            LogHolder.log(4, LogType.CRYPTO, "Could not load default CRLs!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRevocations(CertificateRevocationList a_crl) {
        Enumeration revocations = a_crl.getRevokedCertificates().elements();
        boolean indirectCRL = a_crl.isIndirectCRL();
        Hashtable hashtable = this.m_revokedCerts;
        synchronized (hashtable) {
            while (revocations.hasMoreElements()) {
                RevokedCertificate revCert = (RevokedCertificate)revocations.nextElement();
                X509DistinguishedName issuer = null;
                if (indirectCRL) {
                    issuer = revCert.getCertificateIssuer();
                }
                if (issuer == null) {
                    issuer = a_crl.getIssuer();
                }
                this.m_revokedCerts.put(issuer.toString() + revCert.getSerialNumber().toString(), revCert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevokedCertifcateStore getInstance() {
        Class clazz = class$anon$crypto$RevokedCertifcateStore == null ? (class$anon$crypto$RevokedCertifcateStore = RevokedCertifcateStore.class$("anon.crypto.RevokedCertifcateStore")) : class$anon$crypto$RevokedCertifcateStore;
        synchronized (clazz) {
            if (m_instance == null) {
                m_instance = new RevokedCertifcateStore();
            }
            return m_instance;
        }
    }

    private static String keyValue(JAPCertificate a_cert) {
        return a_cert.getIssuer().toString() + RevokedCertificate.getUniqueSerial(a_cert).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCertificateRevoked(JAPCertificate a_cert) {
        Hashtable hashtable = this.m_revokedCerts;
        synchronized (hashtable) {
            return this.m_revokedCerts.containsKey(RevokedCertifcateStore.keyValue(a_cert));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getRevocationDate(JAPCertificate a_cert) {
        Hashtable hashtable = this.m_revokedCerts;
        synchronized (hashtable) {
            if (this.isCertificateRevoked(a_cert)) {
                RevokedCertificate revCert = (RevokedCertificate)this.m_revokedCerts.get(RevokedCertifcateStore.keyValue(a_cert));
                return revCert.getRevocationDate();
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

