/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509KeyIdentifier;
import anon.crypto.ByteSignature;
import anon.crypto.IMyPublicKey;
import anon.crypto.X509DistinguishedName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class X509AuthorityKeyIdentifier
extends AbstractX509KeyIdentifier {
    public static final String IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    private BigInteger m_serial;
    private GeneralNames m_names;

    public X509AuthorityKeyIdentifier(IMyPublicKey a_publicKey) {
        super(IDENTIFIER, X509AuthorityKeyIdentifier.createDEROctets(a_publicKey, null, null));
        this.createValue();
    }

    public X509AuthorityKeyIdentifier(IMyPublicKey a_publicKey, GeneralNames a_name, BigInteger a_serial) {
        super(IDENTIFIER, X509AuthorityKeyIdentifier.createDEROctets(a_publicKey, a_name, a_serial));
        this.createValue();
    }

    public X509AuthorityKeyIdentifier(IMyPublicKey a_publicKey, X509DistinguishedName a_name, BigInteger a_serial) {
        super(IDENTIFIER, X509AuthorityKeyIdentifier.createDEROctets(a_publicKey, new GeneralNames(new GeneralName(a_name.getX500Name())), a_serial));
        this.createValue();
    }

    public X509AuthorityKeyIdentifier(ASN1Sequence a_extension) {
        super(a_extension);
        this.createValue();
    }

    public String getName() {
        return "AuthorityKeyIdentifier";
    }

    private static byte[] createDEROctets(IMyPublicKey a_publicKey, GeneralNames a_name, BigInteger a_serial) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AuthorityKeyIdentifier aki = a_name != null && a_serial != null ? new AuthorityKeyIdentifier(a_publicKey.getAsSubjectPublicKeyInfo(), a_name, a_serial) : new AuthorityKeyIdentifier(a_publicKey.getAsSubjectPublicKeyInfo());
        try {
            new DEROutputStream(out).writeObject(aki.toASN1Primitive());
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not write DER object to bytes!");
        }
        return out.toByteArray();
    }

    private void createValue() {
        try {
            ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets()));
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance(ais.readObject());
            ais.close();
            byte[] identifier = aki.getKeyIdentifier();
            this.m_value = ByteSignature.toHexString(identifier);
            this.m_serial = aki.getAuthorityCertSerialNumber();
            this.m_names = aki.getAuthorityCertIssuer();
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not read authority key identifier from byte array!");
        }
    }

    public Vector getValues() {
        Vector<String> v = new Vector<String>();
        v.addElement(this.m_value);
        if (this.m_names != null) {
            GeneralName[] names = this.m_names.getNames();
            for (int i = 0; i < names.length; ++i) {
                String name;
                if (names[i].getTagNo() == 4) {
                    name = X500Name.getInstance((ASN1Sequence)names[i].getName().toASN1Primitive()).toString();
                } else {
                    try {
                        name = new String(names[i].getName().toASN1Primitive().getEncoded("DER")).trim();
                    }
                    catch (IOException e) {
                        name = null;
                    }
                }
                v.addElement(name);
            }
        }
        if (this.m_serial != null) {
            v.addElement("authorityCertSerialNumber: " + this.m_serial);
        }
        return v;
    }
}

