/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.MixCascade;
import anon.util.XMLDuration;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataRetentionInformation {
    public static final String XML_ELEMENT_NAME = "DataRetention";
    public static final String XML_ELEMENT_LOGGED_ELEMENTS = "LoggedElements";
    public static final String XML_ELEMENT_RETENTION_PERIOD = "RetentionPeriod";
    public static final String XML_ELEMENT_DESCRIPTION = "Description";
    public static final String XML_ELEMENT_URL = "URL";
    public static final int NOTHING = 1;
    public static final int INPUT_TIME = 2;
    public static final int OUTPUT_TIME = 4;
    public static final int INPUT_CHANNEL_ID = 8;
    public static final int OUTPUT_CHANNEL_ID = 16;
    public static final int INPUT_SOURCE_IP_ADDRESS = 32;
    public static final int INPUT_SOURCE_IP_PORT = 64;
    public static final int OUTPUT_SOURCE_IP_ADDRESS = 128;
    public static final int OUTPUT_SOURCE_IP_PORT = 256;
    public static final int OUTPUT_TARGET_IP_ADDRESS = 512;
    public static final int OUTPUT_TARGET_DOMAIN = 1024;
    public static final String FIELD_NAME_INPUT_SOURCE_IP_ADDRESS_MIX = "INPUT_SOURCE_IP_ADDRESS_MIX";
    public static final String FIELD_NAME_INPUT_SOURCE_IP_PORT_MIX = "INPUT_SOURCE_IP_PORT_MIX";
    private static final int[] FIELDS = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static final String[] FIELD_NAMES = new String[]{"INPUT_TIME", "OUTPUT_TIME", "INPUT_CHANNEL_ID", "OUTPUT_CHANNEL_ID", "INPUT_SOURCE_IP_ADDRESS", "INPUT_SOURCE_IP_PORT", "OUTPUT_SOURCE_IP_ADDRESS", "OUTPUT_SOURCE_IP_PORT", "OUTPUT_TARGET_IP_ADDRESS", "OUTPUT_TARGET_DOMAIN"};
    private XMLDuration m_duration;
    private Hashtable m_hashURLs = new Hashtable();
    private int m_loggedElements = 1;

    public DataRetentionInformation(Element a_drNode) throws XMLParseException {
        XMLUtil.assertNodeName(a_drNode, XML_ELEMENT_NAME);
        Node nodeParent = XMLUtil.getFirstChildByName(a_drNode, XML_ELEMENT_LOGGED_ELEMENTS);
        this.m_loggedElements = 0;
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "InputTime"), false)) {
            this.m_loggedElements += 2;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputTime"), false)) {
            this.m_loggedElements += 4;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "InputChannelID"), false)) {
            this.m_loggedElements += 8;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputChannelID"), false)) {
            this.m_loggedElements += 16;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "InputSourceIPAddress"), false)) {
            this.m_loggedElements += 32;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "InputSourceIPPort"), false)) {
            this.m_loggedElements += 64;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputSourceIPAddress"), false)) {
            this.m_loggedElements += 128;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputSourceIPPort"), false)) {
            this.m_loggedElements += 256;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputTargetIPAddress"), false)) {
            this.m_loggedElements += 512;
        }
        if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(nodeParent, "OutputTargetDomain"), false)) {
            this.m_loggedElements += 1024;
        }
        if (this.m_loggedElements == 0) {
            this.m_loggedElements = 1;
        }
        this.m_duration = new XMLDuration(XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_drNode, XML_ELEMENT_RETENTION_PERIOD), null));
        if (this.m_duration.getSign() < 0) {
            throw new XMLParseException("Negative retention duration is not allowed!");
        }
        NodeList listURLs = XMLUtil.getElementsByTagName(a_drNode, XML_ELEMENT_DESCRIPTION);
        if (listURLs != null) {
            for (int i = 0; i < listURLs.getLength(); ++i) {
                try {
                    this.m_hashURLs.put(XMLUtil.parseAttribute(listURLs.item(i), "lang", "en"), new URL(XMLUtil.parseValue(XMLUtil.getFirstChildByName(listURLs.item(i), XML_ELEMENT_URL), null)));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new XMLParseException(e.getMessage());
                }
            }
        }
    }

    private DataRetentionInformation() {
        this.m_duration = new XMLDuration();
    }

    public static DataRetentionInformation getCascadeDataRetentionInformation(MixCascade a_cascade) {
        DataRetentionInformation drInfo;
        if (a_cascade == null) {
            return null;
        }
        Vector<DataRetentionInformation> vecDrInfo = new Vector<DataRetentionInformation>();
        for (int i = 0; i < a_cascade.getNumberOfMixes(); ++i) {
            if (a_cascade.getMixInfo(i) == null || a_cascade.getMixInfo(i).getDataRetentionInformation() == null) {
                if (i == 0) {
                    return null;
                }
                drInfo = new DataRetentionInformation();
            } else {
                drInfo = a_cascade.getMixInfo(i).getDataRetentionInformation();
                if (!(i != 0 || drInfo == null || drInfo.isLogged(8) && drInfo.isLogged(32))) {
                    return null;
                }
            }
            vecDrInfo.addElement(drInfo);
        }
        drInfo = DataRetentionInformation.getCascadeDataRetentionInformation(vecDrInfo);
        return drInfo;
    }

    private static DataRetentionInformation getCascadeDataRetentionInformation(Vector a_dataRetentionInformations) {
        DataRetentionInformation drInfo = new DataRetentionInformation();
        if (a_dataRetentionInformations == null) {
            return drInfo;
        }
        Vector vec = (Vector)a_dataRetentionInformations.clone();
        if (vec.size() == 0) {
            return drInfo;
        }
        DataRetentionInformation currentDrInfo = (DataRetentionInformation)a_dataRetentionInformations.elementAt(0);
        drInfo.m_loggedElements = currentDrInfo.getLoggedElementIDs();
        drInfo.m_duration = currentDrInfo.m_duration;
        drInfo.m_hashURLs = (Hashtable)currentDrInfo.m_hashURLs.clone();
        block0: for (int i = 1; i < a_dataRetentionInformations.size(); ++i) {
            currentDrInfo = (DataRetentionInformation)a_dataRetentionInformations.elementAt(i);
            drInfo.m_loggedElements = i == a_dataRetentionInformations.size() - 1 ? (drInfo.m_loggedElements &= currentDrInfo.getLoggedElementIDs() | 0x10) : (drInfo.m_loggedElements &= currentDrInfo.getLoggedElementIDs());
            if (drInfo.m_duration.isLongerThan(currentDrInfo.m_duration)) {
                drInfo.m_duration = currentDrInfo.m_duration;
            }
            if (drInfo.m_hashURLs.size() == currentDrInfo.m_hashURLs.size()) {
                Enumeration enumURLKeys = currentDrInfo.m_hashURLs.keys();
                while (enumURLKeys.hasMoreElements()) {
                    Object key = enumURLKeys.nextElement();
                    if (drInfo.m_hashURLs.containsKey(key) && drInfo.m_hashURLs.get(key).equals(currentDrInfo.m_hashURLs.get(key))) continue;
                    drInfo.m_hashURLs.clear();
                    continue block0;
                }
                continue;
            }
            drInfo.m_hashURLs.clear();
        }
        if (drInfo.m_loggedElements == 0) {
            drInfo.m_loggedElements = 1;
        }
        return drInfo;
    }

    public static int getLoggedElementsLength() {
        return FIELDS.length;
    }

    public static int getLoggedElementID(int a_fieldIndex) {
        if (a_fieldIndex < 0 || a_fieldIndex > FIELDS.length) {
            return -1;
        }
        return FIELDS[a_fieldIndex];
    }

    public static String getLoggedElementName(int a_fieldIndex) {
        if (a_fieldIndex < 0 || a_fieldIndex > FIELD_NAMES.length) {
            return null;
        }
        return FIELD_NAMES[a_fieldIndex];
    }

    public boolean isLogged(int a_elementIDs) {
        return (a_elementIDs & this.m_loggedElements) == a_elementIDs;
    }

    public int getLoggedElementIDs() {
        return this.m_loggedElements;
    }

    public URL getURL(String a_language) {
        URL url = (URL)this.m_hashURLs.get(a_language);
        if (url == null) {
            url = (URL)this.m_hashURLs.get("en");
        }
        return url;
    }

    public XMLDuration getDuration() {
        return this.m_duration;
    }
}

