/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Transaction
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "Transaction";
    private static final String XML_ELEM_ACCOUNT_NUMBER = "AccountNumber";
    private static final String XML_ELEM_AMOUNT_EURO_CENT = "AmountEuroCent";
    private static final String XML_ELEM_CREATION_TIME = "CreationTime";
    private static final String XML_ELEM_USED_TIME = "UsedTime";
    private static final String XML_ELEM_PAYMENT_METHOD = "PaymentMethod";
    private static final String XML_ELEM_RATE = "Rate";
    private static final String XML_ATTR_DONE = "done";
    public static final long T_EXPIRE = 1209600000L;
    private long m_lTransactionID;
    private String m_strPaymentMethod;
    private long m_lAccountNr;
    private int m_iAmountInEuroCent;
    private String m_rate;
    private String m_rateID;
    private boolean m_bDone;
    private Timestamp m_tCreation;
    private Timestamp m_tExpiration;
    private Timestamp m_tUsed;

    public Transaction(long a_lTransactionID, long a_lAccountNr, int a_iAmountInEuroCent, String a_rate, String a_rateID, Timestamp a_tCreation, Timestamp a_tUsed, String a_strPaymentMethod, boolean a_bDone) {
        this.m_lTransactionID = a_lTransactionID;
        this.m_strPaymentMethod = a_strPaymentMethod;
        this.m_tUsed = a_tUsed;
        this.m_lAccountNr = a_lAccountNr;
        this.m_iAmountInEuroCent = a_iAmountInEuroCent;
        this.m_rate = a_rate;
        this.m_rateID = a_rateID;
        this.m_bDone = a_bDone;
        this.m_tCreation = a_tCreation;
        this.m_tExpiration = new Timestamp(this.m_tCreation.getTime() + 1209600000L);
    }

    public Transaction(Element a_element) throws XMLParseException {
        XMLUtil.assertNodeName(a_element, XML_ELEMENT_NAME);
        this.m_lTransactionID = XMLUtil.parseAttribute((Node)a_element, "id", 0L);
        if (this.m_lTransactionID <= 0L) {
            throw new XMLParseException(XML_ELEMENT_NAME);
        }
        this.m_bDone = XMLUtil.parseAttribute((Node)a_element, XML_ATTR_DONE, false);
        this.m_lAccountNr = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_ACCOUNT_NUMBER), 0L);
        if (this.m_lAccountNr <= 0L) {
            throw new XMLParseException(XML_ELEM_ACCOUNT_NUMBER);
        }
        this.m_iAmountInEuroCent = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_AMOUNT_EURO_CENT), 0);
        String strTimestamp = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_CREATION_TIME), null);
        if (strTimestamp != null) {
            this.m_tCreation = Timestamp.valueOf(strTimestamp);
        }
        if (this.m_tCreation == null) {
            throw new XMLParseException(XML_ELEM_CREATION_TIME);
        }
        this.m_tExpiration = new Timestamp(this.m_tCreation.getTime() + 1209600000L);
        strTimestamp = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_USED_TIME), null);
        if (strTimestamp != null) {
            this.m_tUsed = Timestamp.valueOf(strTimestamp);
        }
        this.m_strPaymentMethod = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_PAYMENT_METHOD), null);
        this.m_rate = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_element, XML_ELEM_RATE), null);
        this.m_rateID = XMLUtil.parseAttribute(XMLUtil.getFirstChildByName(a_element, XML_ELEM_RATE), "id", null);
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(elemRoot, "id", this.m_lTransactionID);
        XMLUtil.setAttribute(elemRoot, XML_ATTR_DONE, this.m_bDone);
        Element elem = a_doc.createElement(XML_ELEM_ACCOUNT_NUMBER);
        XMLUtil.setValue((Node)elem, this.m_lAccountNr);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_AMOUNT_EURO_CENT);
        XMLUtil.setValue((Node)elem, this.m_iAmountInEuroCent);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_CREATION_TIME);
        XMLUtil.setValue((Node)elem, this.m_tCreation.toString());
        elemRoot.appendChild(elem);
        if (this.m_tUsed != null) {
            elem = a_doc.createElement(XML_ELEM_USED_TIME);
            XMLUtil.setValue((Node)elem, this.m_tUsed.toString());
            elemRoot.appendChild(elem);
        }
        elem = a_doc.createElement(XML_ELEM_PAYMENT_METHOD);
        XMLUtil.setValue((Node)elem, this.m_strPaymentMethod);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement(XML_ELEM_RATE);
        XMLUtil.setValue((Node)elem, this.m_rate);
        XMLUtil.setAttribute(elem, "id", this.m_rateID);
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public String getPaymentMethod() {
        return this.m_strPaymentMethod;
    }

    public long getID() {
        return this.m_lTransactionID;
    }

    public long getAccountNumber() {
        return this.m_lAccountNr;
    }

    public int getAmountEuroCent() {
        return this.m_iAmountInEuroCent;
    }

    public String getRateName() {
        return this.m_rate;
    }

    public String getRateID() {
        return this.m_rateID;
    }

    public boolean isUsed() {
        return this.m_bDone;
    }

    public Timestamp getUsedTime() {
        return this.m_tUsed;
    }

    public Timestamp getCreationTime() {
        return this.m_tCreation;
    }

    public boolean hasExpired() {
        return this.hasExpired(new Timestamp(System.currentTimeMillis()));
    }

    public boolean hasExpired(Timestamp a_tNow) {
        return !this.m_bDone && this.m_tExpiration.before(a_tNow);
    }
}

