/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import java.lang.reflect.Method;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public final class VMPerfDataFile {
    private Hashtable m_tblEntries;
    private Object m_buff;
    private Object m_perf;
    private boolean m_bUsable = false;
    private int m_nextEntry;
    private int m_numEntries;
    private static final Integer PERFDATA_MAGIC_POSITION = new Integer(0);
    private static final Integer PERFDATA_BYTEORDER_POSITION = new Integer(4);
    private static final Integer PERFDATA_ACCESSIBLE_POSITION = new Integer(7);
    private static final Integer PERFDATA_ENTRYOFFSET_POSITION = new Integer(24);
    private static final Integer PERFDATA_NUMENTRIES_POSITION = new Integer(28);
    private static final int PERFDATA_MAGIC = -889274176;
    private static final int PERFDATA_SYNC_TIMEOUT = 5000;
    private static Class m_javaNioByteBufferClass;
    private static Class m_javaNioByteOrderClass;
    private static Class m_sunMiscPerfClass;
    private static Method m_byteBufferPositionMethod;
    private static Method m_byteBufferGetMethod;
    private static Method m_byteBufferGetIntMethod;
    private int m_vmId;
    static /* synthetic */ Class class$java$lang$String;

    public VMPerfDataFile(int a_vmId) {
        this.m_vmId = a_vmId;
        try {
            m_javaNioByteBufferClass = Class.forName("java.nio.ByteBuffer");
            m_javaNioByteOrderClass = Class.forName("java.nio.ByteOrder");
            m_sunMiscPerfClass = Class.forName("sun.misc.Perf");
            m_byteBufferPositionMethod = m_javaNioByteBufferClass.getMethod("position", Integer.TYPE);
            m_byteBufferGetMethod = m_javaNioByteBufferClass.getMethod("get", null);
            m_byteBufferGetIntMethod = m_javaNioByteBufferClass.getMethod("getInt", null);
            this.m_perf = Class.forName("java.security.AccessController").getMethod("doPrivileged", Class.forName("java.security.PrivilegedAction")).invoke(null, Class.forName("sun.misc.Perf$GetPerfAction").newInstance());
            this.m_buff = m_sunMiscPerfClass.getMethod("attach", Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = VMPerfDataFile.class$("java.lang.String")) : class$java$lang$String).invoke(this.m_perf, new Integer(a_vmId), "r");
            if (this.m_buff == null) {
                return;
            }
            if (this.getMagic() != -889274176) {
                return;
            }
            m_javaNioByteBufferClass.getMethod("order", m_javaNioByteOrderClass).invoke(this.m_buff, this.getByteOrder());
            this.m_bUsable = this.buildEntries();
        }
        catch (Exception ex) {
            LogHolder.log(2, LogType.MISC, "Java VM < 1.4 found, can't use multiple-instances feature.");
        }
    }

    private synchronized boolean buildEntries() throws Exception {
        if (this.m_buff == null) {
            return false;
        }
        long timeout = System.currentTimeMillis() + 5000L;
        while (!this.isAccessible()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            return false;
        }
        m_byteBufferPositionMethod.invoke(this.m_buff, PERFDATA_ENTRYOFFSET_POSITION);
        this.m_nextEntry = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        m_byteBufferPositionMethod.invoke(this.m_buff, PERFDATA_NUMENTRIES_POSITION);
        this.m_numEntries = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        this.m_tblEntries = new Hashtable();
        while (this.buildNextEntry()) {
        }
        return true;
    }

    private synchronized boolean buildNextEntry() throws Exception {
        byte b;
        if (this.m_buff == null) {
            return false;
        }
        if (this.m_nextEntry % 4 != 0) {
            return false;
        }
        if (this.m_nextEntry < 0 || this.m_nextEntry >= (Integer)m_javaNioByteBufferClass.getMethod("limit", null).invoke(this.m_buff, (Object[])null)) {
            return false;
        }
        m_byteBufferPositionMethod.invoke(this.m_buff, new Integer(this.m_nextEntry));
        int entryLength = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        if (this.m_nextEntry + entryLength > (Integer)m_javaNioByteBufferClass.getMethod("limit", null).invoke(this.m_buff, (Object[])null) || entryLength == 0) {
            return false;
        }
        int offsetName = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        int vectorLen = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        byte typeCode = (Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        byte units = (Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        int offsetData = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        int maxNameLength = offsetData - offsetName;
        byte[] bytes = new byte[maxNameLength];
        int nameLength = 0;
        while ((b = ((Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null)).byteValue()) != 0 && maxNameLength > nameLength) {
            bytes[nameLength++] = b;
        }
        String name = new String(bytes, 0, nameLength);
        m_byteBufferPositionMethod.invoke(this.m_buff, new Integer(this.m_nextEntry + offsetData));
        if (vectorLen > 0 && typeCode == 66 && units == 5) {
            bytes = new byte[vectorLen];
            int dataLen = 0;
            while ((b = ((Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null)).byteValue()) != 0 && vectorLen > dataLen) {
                bytes[dataLen++] = b;
            }
            String value = new String(bytes, 0, dataLen);
            this.m_tblEntries.put(name, value);
        }
        this.m_nextEntry += entryLength;
        return true;
    }

    private boolean isAccessible() throws Exception {
        if (this.m_buff == null) {
            return false;
        }
        m_byteBufferPositionMethod.invoke(this.m_buff, PERFDATA_ACCESSIBLE_POSITION);
        byte r_value = (Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        return r_value != 0;
    }

    private int getMagic() throws Exception {
        if (this.m_buff == null) {
            return 0;
        }
        Object order = m_javaNioByteBufferClass.getMethod("order", null).invoke(this.m_buff, (Object[])null);
        m_javaNioByteBufferClass.getMethod("order", m_javaNioByteOrderClass).invoke(this.m_buff, m_javaNioByteOrderClass.getField("BIG_ENDIAN").get(null));
        m_byteBufferPositionMethod.invoke(this.m_buff, PERFDATA_MAGIC_POSITION);
        int r_magic = (Integer)m_byteBufferGetIntMethod.invoke(this.m_buff, (Object[])null);
        m_javaNioByteBufferClass.getMethod("order", m_javaNioByteOrderClass).invoke(this.m_buff, order);
        return r_magic;
    }

    private Object getByteOrder() throws Exception {
        if (this.m_buff == null) {
            return null;
        }
        m_byteBufferPositionMethod.invoke(this.m_buff, PERFDATA_BYTEORDER_POSITION);
        byte order = (Byte)m_byteBufferGetMethod.invoke(this.m_buff, (Object[])null);
        if (order == 0) {
            return m_javaNioByteOrderClass.getField("BIG_ENDIAN").get(null);
        }
        return m_javaNioByteOrderClass.getField("LITTLE_ENDIAN").get(null);
    }

    public String getMainClass() {
        if (!this.m_bUsable) {
            return null;
        }
        String value = (String)this.m_tblEntries.get("sun.rt.javaCommand");
        if (value != null) {
            int i = value.indexOf(32);
            if (i > 0) {
                return value.substring(0, i);
            }
            return value;
        }
        return null;
    }

    public int getId() {
        return this.m_vmId;
    }

    public String toString() {
        return this.getMainClass();
    }

    public boolean isUsable() {
        return this.m_bUsable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

