/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.IResourceInstantiator;
import anon.util.ResourceLoader;
import anon.util.URLCoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;

public final class ClassUtil {
    private static final String JAR_FILE = "jar:file:";
    private static final String FILE = "file:";
    private static Hashtable ms_loadedClasses = new Hashtable();
    private static Vector ms_loadedDirectories = new Vector();
    private static boolean ms_bEnableFindSubclasses = true;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$anon$util$ClassUtil;

    private ClassUtil() {
    }

    public static void addFileToClasspath(String a_file) throws IOException, IllegalAccessException {
        File f = new File(a_file);
        ClassUtil.addFileToClasspath(f);
    }

    public static void addFileToClasspath(File a_file) throws IllegalAccessException {
        URL url;
        try {
            url = (URL)(class$java$io$File == null ? (class$java$io$File = ClassUtil.class$("java.io.File")) : class$java$io$File).getMethod("toURL", new Class[0]).invoke((Object)a_file, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalAccessException(ex.getMessage());
        }
        ClassUtil.addURLToClasspath(url);
    }

    public static void addURLToClasspath(URL a_url) throws IllegalAccessException {
        try {
            Object urlClassLoader = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassUtil.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", new Class[0]).invoke((Object)null, new Object[0]);
            Class<?> sysclass = Class.forName("java.net.URLClassLoader");
            Method method = sysclass.getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = ClassUtil.class$("java.net.URL")) : class$java$net$URL);
            (class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = ClassUtil.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method).getMethod("setAccessible", Boolean.TYPE).invoke((Object)method, new Boolean(true));
            method.invoke(urlClassLoader, a_url);
        }
        catch (Throwable t) {
            throw new IllegalAccessException("Error, could not add URL to system classloader");
        }
    }

    public static String getShortClassName(Class a_class) {
        String classname = a_class.getName();
        int pointIndex = classname.lastIndexOf(46);
        if (pointIndex >= 0) {
            classname = classname.substring(pointIndex + 1, classname.length());
        }
        return classname;
    }

    public static Class getClassStatic() {
        return new ClassGetter().getCurrentClassStatic();
    }

    public static String getClassNameStatic() {
        Class c = ClassUtil.getCallingClassStatic();
        if (c == null) {
            return "UNKNOWN";
        }
        return c.getName();
    }

    public static Class getCallingClassStatic() {
        return new ClassGetter().getCallingClassStatic();
    }

    public static String getUserDir() {
        try {
            return System.getProperty("user.dir");
        }
        catch (SecurityException a_e) {
            return new File(".").toString();
        }
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static void enableFindSubclasses(boolean a_benable) {
        ms_bEnableFindSubclasses = a_benable;
    }

    public static boolean isFindSubclassesEnabled() {
        return ms_bEnableFindSubclasses;
    }

    public static Vector findSubclasses(Class a_class) {
        if (!ms_bEnableFindSubclasses) {
            return new Vector();
        }
        ClassUtil.loadClasses(a_class);
        Enumeration classes = ClassUtil.loadClasses(ClassUtil.getCallingClassStatic());
        Vector<Class> subclasses = new Vector<Class>();
        while (classes.hasMoreElements()) {
            Class possibleSubclass = (Class)classes.nextElement();
            if (!a_class.isAssignableFrom(possibleSubclass)) continue;
            subclasses.addElement(possibleSubclass);
        }
        return subclasses;
    }

    public static Enumeration loadClasses() {
        Class callingClass = ClassUtil.getCallingClassStatic();
        ClassUtil.loadClasses(callingClass);
        return ms_loadedClasses.elements();
    }

    public static Enumeration loadClasses(Class a_rootClass) {
        return ClassUtil.loadClasses(a_rootClass, null);
    }

    public static Enumeration loadClasses(File a_classDirectory) {
        return ClassUtil.loadClasses(null, a_classDirectory);
    }

    private static Enumeration loadClasses(Class a_rootClass, File a_directory) {
        block6: {
            PrintStream dummyStream = new PrintStream(new ByteArrayOutputStream());
            Class thisClass = ClassUtil.getClassStatic();
            Class callingClass = ClassUtil.getCallingClassStatic();
            PrintStream syserror = System.err;
            try {
                if (a_directory != null) {
                    System.setErr(dummyStream);
                    ClassUtil.loadClassesInternal(a_rootClass, a_directory);
                    System.setErr(syserror);
                } else if (a_rootClass != null) {
                    System.setErr(dummyStream);
                    ClassUtil.loadClassesInternal(a_rootClass, a_directory);
                    System.setErr(syserror);
                    ClassUtil.loadClassesInternal(thisClass, null);
                    if (callingClass != a_rootClass && callingClass != thisClass) {
                        ClassUtil.loadClassesInternal(callingClass, null);
                    }
                }
            }
            catch (Throwable a_e) {
                System.setErr(syserror);
                if (!(a_e instanceof Exception) || a_e instanceof RuntimeException) break block6;
                a_e.printStackTrace();
            }
        }
        return ms_loadedClasses.elements();
    }

    public static File getClassDirectory(String a_className) {
        if (a_className == null) {
            return null;
        }
        try {
            return ClassUtil.getClassDirectory(Class.forName(a_className));
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static File getFile() {
        ZipFile file = ClassUtil.getJarFile();
        if (file == null) {
            return null;
        }
        return new File(file.getName());
    }

    public static ZipFile getJarFile() {
        return ClassUtil.getJarFile(class$anon$util$ClassUtil == null ? (class$anon$util$ClassUtil = ClassUtil.class$("anon.util.ClassUtil")) : class$anon$util$ClassUtil);
    }

    public static ZipFile getJarFile(Class a_class) {
        if (a_class == null) {
            return null;
        }
        File classParentFile = null;
        try {
            classParentFile = ClassUtil.getClassDirectory(a_class);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "An exception occured while opening the JAR file: ", e);
        }
        if (classParentFile != null && classParentFile.getPath().endsWith(".jar")) {
            try {
                return new ZipFile(classParentFile);
            }
            catch (IOException ioe) {
                LogHolder.log(3, LogType.MISC, "An I/O error occured while opening the JAR file: ", ioe);
            }
        }
        return null;
    }

    public static File getClassDirectory(Class a_class) throws NullPointerException {
        String classResource = "/" + ClassUtil.toRelativeResourcePath(a_class);
        return ClassUtil.getResourceDirectory(classResource, a_class);
    }

    public static File getResourceDirectory(String a_classOrResourceName, Class a_class) throws NullPointerException {
        URL classUrl = a_class.getResource(a_classOrResourceName);
        if (classUrl == null) {
            LogHolder.log(0, LogType.MISC, "Get class resource failed for resource: " + a_classOrResourceName);
            throw new NullPointerException("Class resource not found: " + a_classOrResourceName);
        }
        File file = ResourceLoader.getSystemResource(classUrl.toString());
        if (file == null) {
            String classDirectory = URLCoder.decode(classUrl.toString());
            if (classDirectory.startsWith(JAR_FILE)) {
                if ((classDirectory = classDirectory.substring(JAR_FILE.length(), classDirectory.lastIndexOf(a_classOrResourceName) - 1)).charAt(2) == ':') {
                    classDirectory = classDirectory.substring(1, classDirectory.length());
                }
                classDirectory = ResourceLoader.replaceFileSeparatorsSystemSpecific(classDirectory);
                file = new File(classDirectory);
            } else if (classDirectory.startsWith(FILE)) {
                classDirectory = classDirectory.substring(FILE.length(), classDirectory.lastIndexOf(a_classOrResourceName));
                file = new File(classDirectory);
            } else {
                file = null;
            }
            if (file == null || !file.exists()) {
                return null;
            }
        }
        return file;
    }

    public static String toRelativeResourcePath(Class a_class) {
        String classResource = a_class.getName();
        classResource = classResource.replace('.', '/');
        classResource = classResource + ".class";
        return classResource;
    }

    public static Class getFirstClassFound(File a_file) {
        Hashtable classInstance = new Hashtable();
        ResourceLoader.loadResources("/", a_file, new ClassInstantiator(3), true, true, classInstance);
        if (classInstance.size() == 1) {
            return (Class)classInstance.elements().nextElement();
        }
        return null;
    }

    protected static String getClassPath(boolean a_bPreventLoop) {
        String thisClass = "";
        if (!a_bPreventLoop) {
            try {
                thisClass = ClassUtil.getClassDirectory(class$anon$util$ClassUtil == null ? (class$anon$util$ClassUtil = ClassUtil.class$("anon.util.ClassUtil")) : class$anon$util$ClassUtil).toString() + File.pathSeparator;
            }
            catch (Exception a_e) {
                // empty catch block
            }
            if (thisClass == null || thisClass.length() == 0) {
                try {
                    thisClass = ClassUtil.getResourceDirectory("/JAPMessages_de.properties", class$anon$util$ClassUtil == null ? (class$anon$util$ClassUtil = ClassUtil.class$("anon.util.ClassUtil")) : class$anon$util$ClassUtil).toString() + File.pathSeparator;
                }
                catch (Exception a_e) {
                    // empty catch block
                }
            }
        }
        try {
            return thisClass + System.getProperty("java.class.path");
        }
        catch (SecurityException a_e) {
            return thisClass;
        }
    }

    private static void loadClassesInternal(Class a_rootClass, File a_directory) throws IOException {
        File file;
        if (a_directory != null) {
            file = a_directory;
        } else if (a_rootClass == null || a_rootClass.getName().startsWith("java.") || a_rootClass.getName().startsWith("javax.") || (file = ClassUtil.getClassDirectory(a_rootClass)) == null) {
            return;
        }
        if (ms_loadedDirectories.contains(file.getAbsolutePath())) {
            return;
        }
        ms_loadedDirectories.addElement(file.getAbsolutePath());
        ResourceLoader.loadResources("/", file, new ClassInstantiator(), true, false, ms_loadedClasses);
    }

    private static Class toClass(File a_classFile, File a_classDirectory) {
        Class<?> classObject;
        String classDirectory;
        if (a_classFile == null || !a_classFile.getName().endsWith(".class")) {
            return null;
        }
        int startIndex = a_classDirectory == null || !a_classDirectory.isDirectory() ? 0 : ((classDirectory = a_classDirectory.toString()).endsWith(System.getProperty("file.separator")) ? classDirectory.length() : classDirectory.length() + 1);
        try {
            String className = a_classFile.toString();
            className = className.substring(startIndex, className.lastIndexOf(".class"));
            className = className.replace(File.separatorChar, '.');
            classObject = Class.forName(className);
        }
        catch (Throwable a_e) {
            classObject = null;
        }
        return classObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassInstantiator
    implements IResourceInstantiator {
        private int m_invalidAfterFailure;
        private int m_currentFailure;

        public ClassInstantiator() {
            this.m_invalidAfterFailure = 0;
            this.m_currentFailure = 0;
        }

        public ClassInstantiator(int a_invalidAfterFailure) {
            this.m_invalidAfterFailure = a_invalidAfterFailure;
            this.m_currentFailure = 0;
        }

        public Object getInstance(File a_file, File a_topDirectory) throws IResourceInstantiator.ResourceInstantiationException {
            Class loadedClass = ClassUtil.toClass(a_file, a_topDirectory);
            if (this.m_invalidAfterFailure > 0) {
                this.checkValidity(loadedClass, a_file.getName());
            }
            return loadedClass;
        }

        public Object getInstance(ZipEntry a_entry, ZipFile a_file) throws IResourceInstantiator.ResourceInstantiationException {
            Class loadedClass = ClassUtil.toClass(new File(a_entry.toString()), null);
            if (this.m_invalidAfterFailure > 0) {
                this.checkValidity(loadedClass, a_entry.getName());
            }
            return loadedClass;
        }

        private void checkValidity(Class a_loadedClass, String a_filename) throws IResourceInstantiator.ResourceInstantiationException {
            if (a_loadedClass == null && a_filename.endsWith(".class")) {
                ++this.m_currentFailure;
            }
            if (this.m_currentFailure >= this.m_invalidAfterFailure) {
                throw new IResourceInstantiator.ResourceInstantiationException();
            }
        }

        public Object getInstance(InputStream a_inputStream, String a_resourceName) {
            return null;
        }
    }

    private static class ClassGetter
    extends SecurityManager {
        private ClassGetter() {
        }

        public Class getCurrentClassStatic() {
            Class<?>[] arC = this.getClassContext();
            if (arC == null || arC.length < 3) {
                return null;
            }
            return arC[2];
        }

        public Class getCallingClassStatic() {
            Class<?>[] arC = this.getClassContext();
            if (arC == null || arC.length < 4) {
                return null;
            }
            return arC[3];
        }
    }

    public static final class Package {
        private String m_strPackage;

        public Package(Class a_class) {
            this.m_strPackage = a_class == null || a_class.getName().indexOf(".") < 0 ? "" : a_class.getName().substring(0, a_class.getName().lastIndexOf("."));
        }

        public Package(String a_strPackage) {
            if (this.m_strPackage == null || this.m_strPackage.trim().length() == 0) {
                this.m_strPackage = "";
            } else {
                if (new StringTokenizer(this.m_strPackage).countTokens() > 1) {
                    throw new IllegalArgumentException("Package names may not contain whitespaces!");
                }
                for (int i = 0; i < this.m_strPackage.length(); ++i) {
                    if (Character.isLetterOrDigit(this.m_strPackage.charAt(i)) || this.m_strPackage.charAt(i) == '.') continue;
                    if (this.m_strPackage.charAt(i) == '\\' && this.m_strPackage.length() > i + 5 && this.m_strPackage.charAt(i + 1) == 'u') {
                        boolean bUnicode = true;
                        for (int j = i + 2; j < i + 5; ++j) {
                            if (Character.isDigit(this.m_strPackage.charAt(j))) continue;
                            bUnicode = false;
                            break;
                        }
                        if (bUnicode) {
                            i += 5;
                            continue;
                        }
                    }
                    throw new IllegalArgumentException("Illegal character in package name: " + this.m_strPackage.charAt(i));
                }
                this.m_strPackage = a_strPackage;
            }
        }

        public String getPackage() {
            return this.m_strPackage;
        }
    }
}

