/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.JavaVersionDBEntry;
import anon.infoservice.ListenerInterface;
import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.IProgressCallback;
import anon.util.IProgressCapsule;
import anon.util.JAPMessages;
import anon.util.RecursiveFileTool;
import anon.util.Util;
import anon.util.ZipArchiver;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.FileChooserContentPane;
import gui.dialog.FinishedContentPane;
import gui.dialog.JAPDialog;
import gui.dialog.SimpleWizardContentPane;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPModel;
import jap.gui.LinkRegistrator;
import jarify.JarVerifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.ZipFile;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import logging.LogHolder;
import logging.LogType;
import update.JAPUpdateWizard;
import update.JAPWelcomeWizardPage;

public class SoftwareUpdater {
    public static final int TYPE_CHOOSE = 0;
    public static final int TYPE_STABLE = 1;
    public static final int TYPE_BETA = 2;
    private static final String MSG_ERROR_NO_BACKUP = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".errorNoBackup";
    private static final String MSG_ERROR_DOWNLOAD_FAILED = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".downloadFailed";
    private static final String MSG_ERROR_SAVING_UPDATE_FAILED = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".savingUpdateFailed";
    private static final String MSG_ERROR_VERIFYING_UPDATE_FAILED = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".verifyingUpdateFailed";
    private static final String MSG_ERROR_CHECKING_UPDATE_VERSION = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".errorCheckingUpdateVersion";
    private static final String MSG_ERROR_UNKNOWN = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".errorUnknown";
    private static final String MSG_ERROR_OVERWRITING_FAILED = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".overwritingFailed";
    private static final String MSG_NO_VERSIONS_FOUND = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".errorNoVersionsFound";
    private static final String MSG_HELP_NO_CONNECTION = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".helpNoConnection";
    private static final String MSG_ERROR_RECOMMEND = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".errorRecommend";
    private static final String MSG_FILE_DIRECT_DOWNLOAD = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".fileDirectDownload";
    private static final String MSG_FILE_INSTALLATION = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".fileInstallation";
    private static final String MSG_FILE_INSTALLATION_PATH = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".fileInstallationPath";
    private static final String MSG_FINISHED = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".finished";
    private static final String MSG_RESTART = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".restart";
    private static final String MSG_CHOOSE_VERSION = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".chooseVersion";
    private static final String MSG_UPDATE_JAVA = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".updateJava";
    private static final String MSG_NO_BASE_JAR = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".noBaseJar";
    private static final String MSG_DOWNLOAD_REMAINING = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".downloadRemaining";
    private static final String MSG_SHOW_CHANGES = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".showChanges";
    private static final String MSG_HEAD_UPDATE = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".headUpdate";
    private static final String MSG_CREATE_BACKUP = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".createBackup";
    private static final String MSG_DOWNLOAD_UPDATE = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".downloadUpdate";
    private static final String MSG_SAVE_UPDATE = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".saveUpdate";
    private static final String MSG_VERIFY_UPDATE = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".verifyUpdate";
    private static final String MSG_OVERWRITE = (class$jap$SoftwareUpdater == null ? (class$jap$SoftwareUpdater = SoftwareUpdater.class$("jap.SoftwareUpdater")) : class$jap$SoftwareUpdater).getName() + ".overwrite";
    private static final String ICON_FINISHED = "&#10004;";
    private static final String ICON_BULLET = "&#8226;";
    private final String STR_MESSAGE = "<html>{3} {4}" + JAPMessages.getString(MSG_CREATE_BACKUP) + "...{5}<br>" + "{6} {7}" + JAPMessages.getString(MSG_DOWNLOAD_UPDATE) + "...{8}<br>" + "{9} {10}" + JAPMessages.getString(MSG_SAVE_UPDATE) + "...{11}<br>" + "{12} {13}" + JAPMessages.getString(MSG_VERIFY_UPDATE) + "...{14}<br>" + "{15} {16}" + JAPMessages.getString(MSG_OVERWRITE) + "...{17}" + "</html>";
    private static final File CLASSFILE = ClassUtil.getClassDirectory(ClassUtil.getClassStatic());
    private static final ZipFile JARFILE = ClassUtil.getJarFile(ClassUtil.getClassStatic());
    private JAPVersionInfo m_releaseVersion;
    private JAPVersionInfo m_devVersion;
    private JRadioButton m_radioRelease;
    private JRadioButton m_radioBeta;
    private ButtonGroup m_groupVersion;
    private DateFormat m_dateFormat = DateFormat.getDateInstance(2);
    private JAPController.IRestarter m_Restarter;
    private LinkRegistrator m_registrator;
    private JAPDialog m_dialog;
    private WorkerContentPane paneFetchUpdate;
    private WorkerContentPane initialPane;
    private int m_iType;
    private static final int ACTION_INIT = -1;
    private static final int ACTION_CREATE_BACKUP = 1;
    private static final int ACTION_DOWNLOAD_UPDATE = 2;
    private static final int ACTION_SAVE_UPDATE = 3;
    private static final int ACTION_VERIFY_NEW = 4;
    private static final int ACTION_OVERWRITE = 5;
    private static final Object SYNC_INSTANCE = new Object();
    private static boolean m_bIsShown = false;
    static /* synthetic */ Class class$jap$SoftwareUpdater;
    static /* synthetic */ Class class$anon$infoservice$JAPVersionInfo;

    private String createMessage(int a_iAction, boolean a_bFinished) {
        return this.createMessage(a_iAction, a_bFinished, null);
    }

    private String createMessage(int a_iAction, boolean a_bFinished, String a_value) {
        Object[] objParams = new Object[18];
        for (int i = 0; i < 6; ++i) {
            objParams[i * 3] = ICON_BULLET;
            objParams[i * 3 + 1] = "";
            objParams[i * 3 + 2] = "";
            if (i == a_iAction) {
                objParams[i * 3 + 2] = a_value == null ? "" : a_value;
                if (a_bFinished) {
                    objParams[i * 3] = ICON_FINISHED;
                    if (a_value == null) {
                        objParams[i * 3 + 2] = "";
                    }
                } else {
                    objParams[i * 3] = ICON_BULLET;
                }
                objParams[i * 3 + 1] = "<b>";
                objParams[i * 3 + 2] = (String)objParams[i * 3 + 2] + "</b>";
                continue;
            }
            if (i >= a_iAction) continue;
            objParams[i * 3] = ICON_FINISHED;
        }
        return MessageFormat.format(this.STR_MESSAGE, objParams);
    }

    public static boolean isShown() {
        return m_bIsShown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(JAPVersionInfo a_versionInfo, Component a_parentComponent) {
        Object object = SYNC_INSTANCE;
        synchronized (object) {
            if (m_bIsShown) {
                return;
            }
            m_bIsShown = true;
        }
        SoftwareUpdater dialog = new SoftwareUpdater(a_versionInfo, a_parentComponent);
        dialog.show();
    }

    private SoftwareUpdater(final JAPVersionInfo a_versionInfo, Component a_parentComponent) {
        if (a_parentComponent == null) {
            a_parentComponent = JAPController.getInstance().getCurrentView();
        }
        this.m_dialog = new JAPDialog(a_parentComponent, JAPMessages.getString(MSG_HEAD_UPDATE));
        this.m_dialog.setDefaultCloseOperation(0);
        this.m_registrator = new LinkRegistrator(this.m_dialog.getRootPane(), JAPController.getInstance().getView());
        this.m_iType = a_versionInfo == null ? 0 : (a_versionInfo.getId().equals("/japDevelopment.jnlp") ? 2 : 1);
        this.initialPane = new WorkerContentPane(this.m_dialog, JAPMessages.getString("updateFetchVersionInfo"), new Runnable(){

            public void run() {
                SoftwareUpdater.this.m_releaseVersion = null;
                SoftwareUpdater.this.m_devVersion = null;
                if (a_versionInfo == null) {
                    SoftwareUpdater.this.m_releaseVersion = InfoServiceHolder.getInstance().getJAPVersionInfo(1);
                    SoftwareUpdater.this.m_devVersion = InfoServiceHolder.getInstance().getJAPVersionInfo(2);
                    Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = SoftwareUpdater.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).update(SoftwareUpdater.this.m_releaseVersion);
                    Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = SoftwareUpdater.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).update(SoftwareUpdater.this.m_devVersion);
                }
                if (SoftwareUpdater.this.m_releaseVersion == null) {
                    SoftwareUpdater.this.m_releaseVersion = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = SoftwareUpdater.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById("/japRelease.jnlp");
                }
                if (SoftwareUpdater.this.m_devVersion == null) {
                    SoftwareUpdater.this.m_devVersion = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = SoftwareUpdater.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById("/japDevelopment.jnlp");
                }
            }
        }){

            public boolean isMoveBackAllowed() {
                return false;
            }
        };
        final SimpleWizardContentPane paneErrorNoVersionsFound = new SimpleWizardContentPane(this.m_dialog, "<font color=\"FF0000\">" + JAPMessages.getString(MSG_NO_VERSIONS_FOUND) + JAPMessages.getString(MSG_HELP_NO_CONNECTION) + "</font>", (DialogContentPane)this.initialPane){

            public boolean isSkippedAsNextContentPane() {
                return SoftwareUpdater.this.m_releaseVersion != null || SoftwareUpdater.this.m_devVersion != null;
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }
        };
        final SimpleWizardContentPane paneUpdateAvailable = new SimpleWizardContentPane(this.m_dialog, "Dummy", paneErrorNoVersionsFound){

            public boolean isMoveForwardAllowed() {
                return paneErrorNoVersionsFound.isSkippedAsNextContentPane();
            }

            public DialogContentPane.CheckError checkYesOK() {
                if (SoftwareUpdater.this.m_groupVersion.getSelection() == null) {
                    return new DialogContentPane.CheckError(JAPMessages.getString(MSG_CHOOSE_VERSION));
                }
                JAPVersionInfo info = SoftwareUpdater.this.m_radioRelease.isSelected() ? SoftwareUpdater.this.m_releaseVersion : SoftwareUpdater.this.m_devVersion;
                if (!info.isJavaVersionStillSupported()) {
                    this.setText(JAPMessages.getString(JAPUpdateWizard.MSG_JAVA_TOO_OLD, new Object[]{JavaVersionDBEntry.CURRENT_JAVA_VERSION, info.getSupportedJavaVersion()}));
                    String strMsg = JAPMessages.getString("updateReleaseVersion");
                    if (info == SoftwareUpdater.this.m_devVersion) {
                        strMsg = JAPMessages.getString("updateDevelopmentVersion");
                    }
                    strMsg = strMsg + ": " + JAPMessages.getString(MSG_UPDATE_JAVA);
                    return new DialogContentPane.CheckError(strMsg);
                }
                return null;
            }

            public DialogContentPane.CheckError checkUpdate() {
                JAPVersionInfo info;
                if (SoftwareUpdater.this.m_releaseVersion != null && SoftwareUpdater.this.m_iType != 2) {
                    SoftwareUpdater.this.m_radioRelease.setText("<html>" + JAPMessages.getString("JAP.version") + ": " + SoftwareUpdater.this.m_releaseVersion.getJapVersion() + "<br/>" + "</html>");
                } else {
                    SoftwareUpdater.this.m_radioRelease.setVisible(false);
                }
                if (SoftwareUpdater.this.m_devVersion != null && SoftwareUpdater.this.m_iType != 1) {
                    SoftwareUpdater.this.m_radioBeta.setText("<html>" + JAPMessages.getString("JAP.version") + ": " + SoftwareUpdater.this.m_devVersion.getJapVersion() + "-beta" + "<br/>" + "(" + JAPMessages.getString("updateDevelopmentVersion") + ")" + "</html>");
                } else {
                    SoftwareUpdater.this.m_radioBeta.setVisible(false);
                }
                if (SoftwareUpdater.this.m_iType == 1) {
                    info = SoftwareUpdater.this.m_releaseVersion != null ? SoftwareUpdater.this.m_releaseVersion : SoftwareUpdater.this.m_devVersion;
                } else {
                    if (SoftwareUpdater.this.m_iType == 0) {
                        // empty if block
                    }
                    info = SoftwareUpdater.this.m_devVersion != null ? SoftwareUpdater.this.m_devVersion : SoftwareUpdater.this.m_releaseVersion;
                }
                String text = "00.20.010".compareTo(info.getJapVersion()) >= 0 ? JAPMessages.getString("japUpdate_YouHaveAlreadyTheNewestVersion") : JAPMessages.getString("japUpdate_NewVersionAvailable");
                if (!SoftwareUpdater.this.m_radioRelease.isVisible()) {
                    SoftwareUpdater.this.m_radioBeta.setSelected(true);
                } else if (!SoftwareUpdater.this.m_radioBeta.isVisible()) {
                    SoftwareUpdater.this.m_radioRelease.setSelected(true);
                } else if ("00.20.010".compareTo(SoftwareUpdater.this.m_releaseVersion.getJapVersion()) < 0) {
                    SoftwareUpdater.this.m_radioRelease.setSelected(true);
                } else if ("00.20.010".compareTo(info.getJapVersion()) < 0) {
                    SoftwareUpdater.this.m_radioBeta.setSelected(true);
                }
                this.setText(text);
                return null;
            }

            public void doAfterUpdate() {
                if (SoftwareUpdater.this.m_radioRelease.isSelected()) {
                    SoftwareUpdater.this.m_radioRelease.doClick();
                } else if (SoftwareUpdater.this.m_radioBeta.isSelected()) {
                    SoftwareUpdater.this.m_radioBeta.doClick();
                }
            }
        };
        JComponent contentPane = paneUpdateAvailable.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        this.m_radioRelease = new JRadioButton();
        this.m_radioRelease.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                URL url = null;
                try {
                    url = new URL(JAPMessages.getString(JAPWelcomeWizardPage.MSG_CHANGELOG_URL) + "#" + SoftwareUpdater.this.m_releaseVersion.getJapVersion());
                }
                catch (MalformedURLException e) {
                    LogHolder.log(2, LogType.MISC, e);
                }
                paneUpdateAvailable.printStatusMessage(JAPMessages.getString("updateReleaseVersion") + ": " + JAPMessages.getString(MSG_SHOW_CHANGES), 1, url);
            }
        });
        this.m_radioBeta = new JRadioButton();
        this.m_radioBeta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                URL url = null;
                try {
                    url = new URL(JAPMessages.getString(JAPWelcomeWizardPage.MSG_CHANGELOG_URL_BETA) + "#" + SoftwareUpdater.this.m_devVersion.getJapVersion() + "-beta");
                }
                catch (MalformedURLException e) {
                    LogHolder.log(2, LogType.MISC, e);
                }
                paneUpdateAvailable.printStatusMessage(JAPMessages.getString("updateDevelopmentVersion") + ": " + JAPMessages.getString(MSG_SHOW_CHANGES), 2, url);
            }
        });
        this.m_groupVersion = new ButtonGroup();
        this.m_groupVersion.add(this.m_radioRelease);
        this.m_groupVersion.add(this.m_radioBeta);
        contentPane.add((Component)this.m_radioRelease, constraints);
        ++constraints.gridy;
        contentPane.add((Component)this.m_radioBeta, constraints);
        final FileChooserContentPane fileChooser = new FileChooserContentPane(this.m_dialog, JAPMessages.getString(MSG_NO_BASE_JAR), CLASSFILE.getAbsolutePath(), 2, "__FILE_CHOOSER_OPEN", new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".jar");
            }

            public String getDescription() {
                return ".jar";
            }
        }, (DialogContentPane)paneUpdateAvailable){

            public DialogContentPane.CheckError checkYesOK() {
                DialogContentPane.CheckError errors = super.checkYesOK();
                if (errors != null) {
                    return errors;
                }
                if (this.getFile().isDirectory()) {
                    return new DialogContentPane.CheckError(JAPMessages.getString(FileChooserContentPane.MSG_CHOOSE_FILE));
                }
                return null;
            }

            public boolean isSkippedAsPreviousContentPane() {
                return this.isSkippedAsNextContentPane();
            }

            public boolean isSkippedAsNextContentPane() {
                return JARFILE != null;
            }
        };
        final UpdateThread thUpdate = new UpdateThread();
        this.paneFetchUpdate = new WorkerContentPane(this.m_dialog, this.createMessage(-1, false), fileChooser, thUpdate, thUpdate){

            public boolean hideButtonCancel() {
                return false;
            }

            public DialogContentPane.CheckError checkUpdate() {
                if (thUpdate != null) {
                    thUpdate.setCurrentFileIfNull(fileChooser.getFile());
                }
                return super.checkUpdate();
            }
        };
        SimpleWizardContentPane paneError = new SimpleWizardContentPane(this.m_dialog, JAPMessages.getString(MSG_ERROR_UNKNOWN), new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR), 0), this.paneFetchUpdate){

            public boolean isSkippedAsNextContentPane() {
                return thUpdate != null && thUpdate.getStatus() == 0;
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }

            public boolean isMoveBackAllowed() {
                return false;
            }

            public boolean hideButtonYesOK() {
                return true;
            }

            public DialogContentPane.CheckError checkUpdate() {
                this.getContentPane().removeAll();
                String strReason = thUpdate.getFailedReason();
                if (strReason == null) {
                    strReason = JAPMessages.getString(MSG_ERROR_UNKNOWN);
                }
                this.setText("<font color=\"FF0000\">" + strReason + "</font>");
                GridBagConstraints constraintsFinished = new GridBagConstraints();
                constraintsFinished.gridx = 0;
                constraintsFinished.gridy = -1;
                constraintsFinished.anchor = 17;
                SoftwareUpdater.this.m_registrator.addBrowserInstallationInfo(this.getContentPane(), constraintsFinished, JAPMessages.getString(MSG_FILE_INSTALLATION) + "...", JAPMessages.getString(MSG_FILE_INSTALLATION_PATH), false, 1);
                return null;
            }
        };
        paneError.getContentPane().setLayout(new GridBagLayout());
        FinishedContentPane paneFinished = new FinishedContentPane(this.m_dialog, "Dummy", paneError){

            public DialogContentPane.CheckError checkUpdate() {
                if (thUpdate.getUpdatedFile() != null && thUpdate.getUpdatedFile().equals(CLASSFILE)) {
                    this.setText(JAPMessages.getString(MSG_FINISHED) + " " + JAPMessages.getString(MSG_RESTART));
                } else {
                    this.setText(JAPMessages.getString(MSG_FINISHED));
                }
                return null;
            }

            public DialogContentPane.CheckError checkYesOK() {
                if (thUpdate != null && thUpdate.getStatus() == 0 && thUpdate.getUpdatedFile() != null && thUpdate.getUpdatedFile().equals(CLASSFILE)) {
                    SoftwareUpdater.this.m_Restarter = null;
                    JAPController.goodBye(false);
                }
                return null;
            }
        };
        this.m_dialog.setAlwaysOnTop(true);
        this.m_dialog.setResizable(false);
    }

    private void show() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SoftwareUpdater.this.initialPane.pack();
                SoftwareUpdater.this.m_dialog.setVisible(true);
                SoftwareUpdater.this.m_dialog.dispose();
                if (SoftwareUpdater.this.m_Restarter != null) {
                    JAPController.getInstance().setRestarter(SoftwareUpdater.this.m_Restarter);
                }
                Object object = SYNC_INSTANCE;
                synchronized (object) {
                    m_bIsShown = false;
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UpdateThread
    extends Observable
    implements Runnable,
    IProgressCapsule,
    IProgressCallback {
        private int m_iValue = 0;
        private int m_iRange = 0;
        private long m_lFileSize = 0L;
        private int m_iStatus = -1;
        private JAPVersionInfo m_versionInfo;
        private String m_strMessage = SoftwareUpdater.access$2300(SoftwareUpdater.this, -1, false);
        private String m_strCurrentVersion = "00.20.010";
        private String m_strFailedReason;
        private File m_fileAktJapJar = SoftwareUpdater.access$1500();
        private File m_fileNewJapJar;
        private File m_fileJapJarCopy;
        private String m_strAktJapJarFileName;
        private String m_strAktJapJarPath;
        private String m_strAktJapJarExtension;
        private String m_strTempDirectory;
        private boolean m_bCommandLineVersion = false;
        private static final String EXTENSION_BACKUP = ".backup";
        private static final String EXTENSION_NEW = ".new";

        private UpdateThread() {
        }

        public String getFailedReason() {
            return this.m_strFailedReason;
        }

        public int getCurrentMaximum() {
            return this.m_iRange;
        }

        public long getCurrentSize() {
            return this.m_lFileSize;
        }

        public void setValue(int a_iValue) {
            this.m_iValue = a_iValue;
            this.setChanged();
            this.notifyObservers(this);
        }

        private boolean verifyUpdate() {
            String strCommandlineVersion;
            this.m_iValue = 520;
            this.m_strMessage = SoftwareUpdater.this.createMessage(4, false);
            this.setChanged();
            this.notifyObservers(this);
            if (!JarVerifier.verify(this.m_fileNewJapJar, JAPModel.getJAPCodeSigningCert())) {
                this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_VERIFYING_UPDATE_FAILED);
                LogHolder.log(2, LogType.MISC, "Verifying update file failed!");
                return false;
            }
            this.setValue(560);
            if (this.m_bCommandLineVersion && ((strCommandlineVersion = this.getJarVersion(this.m_fileNewJapJar)) == null || !strCommandlineVersion.equals(this.m_versionInfo.getJapVersion()))) {
                this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_CHECKING_UPDATE_VERSION, strCommandlineVersion);
                LogHolder.log(2, LogType.MISC, "Update has wrong version number: " + strCommandlineVersion);
                return false;
            }
            this.m_strMessage = SoftwareUpdater.this.createMessage(4, true);
            this.setValue(600);
            return true;
        }

        public void run() {
            int i;
            this.m_iStatus = 1;
            this.m_strFailedReason = null;
            byte[] byNewFile = null;
            boolean bIncremental = true;
            boolean bAllowIncremental = true;
            this.m_versionInfo = SoftwareUpdater.this.m_radioRelease.isSelected() ? SoftwareUpdater.this.m_releaseVersion : SoftwareUpdater.this.m_devVersion;
            this.parsePathToJapJar();
            bAllowIncremental = this.renameJapJar();
            if (this.m_iStatus != 1) {
                this.resetChanges(true);
                return;
            }
            boolean bSavingSuccessful = false;
            URL[] codeBases = this.m_versionInfo.getCodeBase();
            boolean[] bForceFullUpdate = new boolean[codeBases.length];
            for (i = 0; i < bForceFullUpdate.length; ++i) {
                bForceFullUpdate[i] = false;
            }
            for (i = 0; i < codeBases.length && !Thread.currentThread().isInterrupted(); ++i) {
                URL currentCodeBase = codeBases[i];
                URL jarUrl = null;
                try {
                    if (!bForceFullUpdate[i] && bAllowIncremental && this.m_versionInfo.isIncrementalAllowed(i)) {
                        bIncremental = true;
                        jarUrl = new URL(currentCodeBase, this.m_versionInfo.getJAPJarFileName() + "?version-id=" + this.m_versionInfo.getJapVersion() + "&current-version-id=" + this.m_strCurrentVersion);
                    } else {
                        bIncremental = false;
                        jarUrl = new URL(currentCodeBase, this.m_versionInfo.getJAPJarFileName() + "?version-id=" + this.m_versionInfo.getJapVersion());
                    }
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, e);
                    continue;
                }
                int port = jarUrl.getPort();
                if (port == -1) {
                    port = 80;
                }
                if ((byNewFile = this.doDownload(new ListenerInterface(jarUrl.getHost(), port), jarUrl.getFile())) == null) {
                    this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_DOWNLOAD_FAILED) + JAPMessages.getString(MSG_HELP_NO_CONNECTION);
                    continue;
                }
                if (bIncremental) {
                    if (!this.applyJARDiffJAPJar(byNewFile)) {
                        bForceFullUpdate[i] = true;
                        --i;
                        continue;
                    }
                } else if (!this.createNewJAPJar(byNewFile)) continue;
                if (this.verifyUpdate()) {
                    bSavingSuccessful = true;
                    break;
                }
                if (!bIncremental) continue;
                bForceFullUpdate[i] = true;
                --i;
            }
            if (!bSavingSuccessful) {
                this.m_iStatus = 3;
                this.resetChanges(true);
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                this.m_iStatus = 2;
                this.resetChanges(true);
                return;
            }
            if (this.overwriteJapJar()) {
                this.m_iStatus = 0;
                this.resetChanges(false);
            } else {
                this.resetChanges(true);
                if (Thread.currentThread().isInterrupted()) {
                    this.m_iStatus = 2;
                } else if (this.m_iStatus == 1) {
                    this.m_iStatus = 3;
                }
            }
        }

        public File getUpdatedFile() {
            return this.m_fileAktJapJar;
        }

        public void setCurrentFileIfNull(File a_file) {
            this.m_fileAktJapJar = a_file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean createNewJAPJar(byte[] a_bBytes) {
            boolean bl;
            this.m_strMessage = SoftwareUpdater.this.createMessage(3, false);
            this.m_iValue = 420;
            this.setChanged();
            this.notifyObservers(this);
            FileOutputStream fos = null;
            try {
                try {
                    this.m_fileNewJapJar = this.m_strTempDirectory == null ? new File(this.m_strAktJapJarPath + this.m_strAktJapJarFileName + this.m_versionInfo.getJapVersion() + EXTENSION_NEW + this.m_strAktJapJarExtension) : new File(this.m_strTempDirectory + this.m_fileAktJapJar.getName());
                    fos = new FileOutputStream(this.m_fileNewJapJar);
                    fos.write(a_bBytes);
                    fos.flush();
                    this.m_strMessage = SoftwareUpdater.this.createMessage(3, true);
                    this.m_iValue = 520;
                    this.setChanged();
                    this.notifyObservers(this);
                    bl = true;
                    Object var6_5 = null;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, e);
                    this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_SAVING_UPDATE_FAILED);
                    boolean bl2 = false;
                    Object var6_6 = null;
                    try {
                        fos.close();
                        return bl2;
                    }
                    catch (Exception a_e) {
                        // empty catch block
                    }
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {}
                catch (Exception a_e) {
                    throw throwable;
                }
                fos.close();
                throw throwable;
            }
            try {}
            catch (Exception a_e) {
                // empty catch block
                return bl;
            }
            fos.close();
            return bl;
        }

        private synchronized boolean applyJARDiffJAPJar(byte[] a_bBytes) {
            this.m_strMessage = SoftwareUpdater.this.createMessage(3, false);
            this.setValue(420);
            try {
                this.m_fileNewJapJar = this.m_strTempDirectory == null ? new File(this.m_strAktJapJarPath + this.m_strAktJapJarFileName + this.m_versionInfo.getJapVersion() + EXTENSION_NEW + this.m_strAktJapJarExtension) : new File(this.m_strTempDirectory + this.m_fileAktJapJar.getName());
                ZipArchiver archiver = new ZipArchiver(new ZipFile(this.m_fileAktJapJar));
                Observer observer = new Observer(){

                    public void update(Observable a_observable, Object a_object) {
                        if (a_object instanceof ZipArchiver.ZipEvent) {
                            ZipArchiver.ZipEvent event = (ZipArchiver.ZipEvent)a_object;
                            UpdateThread.this.m_iValue = event.getValue() * 100 / event.getMaximum() + 420;
                            UpdateThread.this.setChanged();
                            UpdateThread.this.notifyObservers(UpdateThread.this);
                        }
                    }
                };
                archiver.addObserver(observer);
                if (archiver.applyDiff(this.m_fileNewJapJar, a_bBytes) != 0) {
                    this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_SAVING_UPDATE_FAILED);
                    return false;
                }
                this.m_strMessage = SoftwareUpdater.this.createMessage(3, true);
                this.m_iValue = 520;
                this.setChanged();
                this.notifyObservers(this);
                return true;
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, e);
                this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_SAVING_UPDATE_FAILED);
                return false;
            }
        }

        private void parsePathToJapJar() {
            try {
                this.m_strAktJapJarFileName = this.m_fileAktJapJar.getName();
                this.m_strAktJapJarPath = this.m_fileAktJapJar.getCanonicalPath();
                this.m_strAktJapJarPath = this.m_strAktJapJarPath.substring(0, this.m_strAktJapJarPath.length() - this.m_strAktJapJarFileName.length());
                this.m_strAktJapJarExtension = this.m_fileAktJapJar.getName();
                int i = this.m_strAktJapJarExtension.lastIndexOf(46);
                this.m_strAktJapJarExtension = this.m_strAktJapJarExtension.substring(i);
                this.m_strAktJapJarFileName = this.m_strAktJapJarFileName.substring(0, i);
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.MISC, e);
            }
        }

        private void resetChanges(boolean a_bDeleteBackup) {
            if (a_bDeleteBackup && this.m_fileJapJarCopy != null) {
                this.m_fileJapJarCopy.delete();
            }
            if (this.m_fileNewJapJar != null) {
                this.m_fileNewJapJar.delete();
            }
        }

        private String getJarVersion(File a_file) {
            String strVersion = null;
            try {
                int index;
                String command = "java -jar \"" + a_file.getCanonicalPath() + "\" -v";
                strVersion = AbstractOS.getInstance().executeRuntime(command);
                BufferedReader reader = new BufferedReader(new StringReader(strVersion));
                strVersion = reader.readLine();
                strVersion = strVersion != null && (index = strVersion.toLowerCase().indexOf("version:")) > 0 ? strVersion.substring(index + "version:".length()).trim() : null;
            }
            catch (IOException e1) {
                LogHolder.log(2, LogType.MISC, "Could not get version info from file to update!", e1);
                strVersion = null;
            }
            return strVersion;
        }

        private boolean renameJapJar() {
            LogHolder.log(7, LogType.MISC, "Start to make a copy of old jar-File!");
            this.m_strMessage = SoftwareUpdater.this.createMessage(1, false);
            this.setChanged();
            this.notifyObservers(this);
            boolean bAllowIncremental = JarVerifier.verify(this.m_fileAktJapJar, JAPModel.getJAPCodeSigningCert());
            this.m_iValue = 5;
            this.setChanged();
            this.notifyObservers(this);
            String strCommandlineVersion = this.getJarVersion(this.m_fileAktJapJar);
            if (strCommandlineVersion != null) {
                this.m_bCommandLineVersion = true;
                if (bAllowIncremental && !this.m_fileAktJapJar.equals(ClassUtil.getClassDirectory(ClassUtil.getClassStatic()))) {
                    this.m_strCurrentVersion = strCommandlineVersion;
                    LogHolder.log(4, LogType.MISC, "Version to update from: '" + this.m_strCurrentVersion + "'");
                }
            }
            try {
                this.m_iRange = 15;
                this.m_lFileSize = this.m_fileAktJapJar.length();
                try {
                    this.m_fileJapJarCopy = new File(this.m_strAktJapJarPath + this.m_strAktJapJarFileName + this.m_strCurrentVersion + EXTENSION_BACKUP + this.m_strAktJapJarExtension);
                    this.m_fileJapJarCopy.delete();
                    Util.copyStream(new FileInputStream(this.m_fileAktJapJar), new FileOutputStream(this.m_fileJapJarCopy), this);
                }
                catch (IOException a_e) {
                    this.setValue(5);
                    this.m_strTempDirectory = AbstractOS.getInstance().getTempPath();
                    if (this.m_strTempDirectory == null) {
                        throw a_e;
                    }
                    this.m_fileJapJarCopy = new File(this.m_strTempDirectory + this.m_strAktJapJarFileName + this.m_strCurrentVersion + EXTENSION_BACKUP + this.m_strAktJapJarExtension);
                    this.m_fileJapJarCopy.delete();
                    Util.copyStream(new FileInputStream(this.m_fileAktJapJar), new FileOutputStream(this.m_fileJapJarCopy), this);
                }
                this.m_strMessage = SoftwareUpdater.this.createMessage(1, true);
                this.setValue(20);
            }
            catch (IOException a_e) {
                this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_NO_BACKUP);
                this.m_iStatus = 3;
            }
            return bAllowIncremental;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private byte[] doDownload(ListenerInterface a_targetInterface, String a_fileName) {
            block36: {
                block32: {
                    block35: {
                        block31: {
                            block29: {
                                block30: {
                                    connection = null;
                                    in = null;
                                    newJarBuff = null;
                                    try {
                                        try {
                                            LogHolder.log(5, LogType.NET, "Try to download: " + a_fileName);
                                            this.m_strMessage = SoftwareUpdater.access$2300(SoftwareUpdater.this, 2, false);
                                            this.setValue(20);
                                            response = null;
                                            bAnonProxy = false;
                                            proxyInterface = JAPModel.getInstance().getUpdateProxyInterface();
                                            for (i = 0; i < 2 && !Thread.currentThread().isInterrupted(); ++i) {
                                                if (i == 1) {
                                                    bAnonProxy = true;
                                                }
                                                if ((proxyInterfaceGetter = proxyInterface.getProxyInterface(bAnonProxy)) == null) continue;
                                                try {
                                                    connection = HTTPConnectionFactory.getInstance().createHTTPConnection(a_targetInterface, proxyInterfaceGetter.getProxyInterface());
                                                    connection.setTimeout(300000);
                                                    response = connection.Get(a_fileName);
                                                }
                                                catch (Exception a_e) {
                                                    LogHolder.log(2, LogType.NET, a_e);
                                                    continue;
                                                }
                                                if (response.getStatusCode() == 200) break;
                                                LogHolder.log(4, LogType.NET, "Update broke with status code: " + response.getStatusCode());
                                            }
                                            if (response == null || response.getStatusCode() != 200) {
                                                i = null;
                                                var20_15 = null;
                                                SoftwareUpdater.access$3400(SoftwareUpdater.this).clearStatusMessage();
                                                if (connection == null) break block29;
                                                break block30;
                                            }
                                            LogHolder.log(5, LogType.NET, "Connection to update server established, continue update...");
                                            lenTotal = response.getHeaderAsInt("Content-Length");
                                            in = response.getInputStream();
                                            buff = new byte[2048];
                                            newJarBuff = new byte[lenTotal];
                                            lenRemaining = lenTotal;
                                            currentPos = 0;
                                            len = in.read(buff);
                                            while (len > 0) {
                                                System.arraycopy(buff, 0, newJarBuff, currentPos, len);
                                                value = (int)(400L * (long)(currentPos += len) / (long)lenTotal);
                                                oldValue = this.m_iValue;
                                                this.m_iValue = value + 20;
                                                finalLenRemaining = lenRemaining -= len;
                                                if (oldValue != this.m_iValue) {
                                                    SwingUtilities.invokeAndWait(new Runnable(){

                                                        public void run() {
                                                            SoftwareUpdater.this.paneFetchUpdate.printStatusMessage(JAPMessages.getString(MSG_DOWNLOAD_REMAINING) + ": " + Util.formatBytesValueWithUnit(finalLenRemaining));
                                                        }
                                                    });
                                                }
                                                this.setChanged();
                                                this.notifyObservers(this);
                                                if (Thread.currentThread().isInterrupted()) {
                                                    var18_31 = null;
                                                    break block31;
                                                }
                                                len = in.read(buff);
                                            }
                                            this.m_strMessage = SoftwareUpdater.access$2300(SoftwareUpdater.this, 2, true);
                                            this.setValue(420);
                                            break block32;
                                        }
                                        catch (Exception e) {
                                            LogHolder.log(2, LogType.NET, e);
                                            var20_18 = null;
                                            SoftwareUpdater.access$3400(SoftwareUpdater.this).clearStatusMessage();
                                            if (connection != null) {
                                                try {
                                                    connection.stop();
                                                }
                                                catch (Exception a_e) {
                                                    // empty catch block
                                                }
                                            }
                                            if (in == null) return newJarBuff;
                                            try {
                                                in.close();
                                                return newJarBuff;
                                            }
                                            catch (Exception a_e) {
                                                return newJarBuff;
                                            }
                                        }
                                    }
                                    catch (Throwable var19_32) {
                                        block34: {
                                            var20_19 = null;
                                            SoftwareUpdater.access$3400(SoftwareUpdater.this).clearStatusMessage();
                                            if (connection != null) {
                                                ** try [egrp 3[TRYBLOCK] [9 : 485->492)] { 
lbl85:
                                                // 1 sources

                                                connection.stop();
                                                break block34;
lbl87:
                                                // 1 sources

                                                catch (Exception a_e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (in == null) throw var19_32;
                                        ** try [egrp 4[TRYBLOCK] [10 : 499->507)] { 
lbl92:
                                        // 1 sources

                                        in.close();
                                        throw var19_32;
lbl94:
                                        // 1 sources

                                        catch (Exception a_e) {
                                            // empty catch block
                                        }
                                        throw var19_32;
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [9 : 485->492)] { 
lbl99:
                                // 1 sources

                                connection.stop();
                                break block29;
lbl101:
                                // 1 sources

                                catch (Exception a_e) {
                                    // empty catch block
                                }
                            }
                            if (in == null) return i;
                            ** try [egrp 4[TRYBLOCK] [10 : 499->507)] { 
lbl106:
                            // 1 sources

                            in.close();
                            return i;
lbl108:
                            // 1 sources

                            catch (Exception a_e) {
                                // empty catch block
                            }
                            return i;
                        }
                        var20_16 = null;
                        SoftwareUpdater.access$3400(SoftwareUpdater.this).clearStatusMessage();
                        if (connection != null) {
                            ** try [egrp 3[TRYBLOCK] [9 : 485->492)] { 
lbl116:
                            // 1 sources

                            connection.stop();
                            break block35;
lbl118:
                            // 1 sources

                            catch (Exception a_e) {
                                // empty catch block
                            }
                        }
                    }
                    if (in == null) return var18_31;
                    ** try [egrp 4[TRYBLOCK] [10 : 499->507)] { 
lbl123:
                    // 1 sources

                    in.close();
                    return var18_31;
lbl125:
                    // 1 sources

                    catch (Exception a_e) {
                        // empty catch block
                    }
                    return var18_31;
                }
                var20_17 = null;
                SoftwareUpdater.access$3400(SoftwareUpdater.this).clearStatusMessage();
                if (connection != null) {
                    ** try [egrp 3[TRYBLOCK] [9 : 485->492)] { 
lbl133:
                    // 1 sources

                    connection.stop();
                    break block36;
lbl135:
                    // 1 sources

                    catch (Exception a_e) {
                        // empty catch block
                    }
                }
            }
            if (in == null) return newJarBuff;
            try {}
            catch (Exception a_e) {}
            in.close();
            return newJarBuff;
            return newJarBuff;
        }

        private boolean overwriteJapJar() {
            this.m_strMessage = SoftwareUpdater.this.createMessage(5, false);
            this.setValue(600);
            if (this.getUpdatedFile() != null && this.getUpdatedFile().equals(CLASSFILE)) {
                final JAPController.IRestarter restarter = JAPController.getInstance().getRestarter();
                SoftwareUpdater.this.m_Restarter = restarter;
                JAPController.getInstance().setRestarter(new JAPController.IRestarter(){

                    public void exec(String[] a_args) throws IOException {
                        restarter.exec(a_args);
                    }

                    public boolean isConfigFileSaved() {
                        return false;
                    }

                    public boolean hideWarnings() {
                        return true;
                    }
                });
                JAPController.getInstance().saveConfigFile();
            }
            this.setValue(620);
            boolean bWriteProtected = false;
            try {
                if (this.m_fileAktJapJar != null && this.m_fileAktJapJar.equals(CLASSFILE)) {
                    GUIUtils.setLoadImages(false);
                }
                if (Thread.currentThread().isInterrupted()) {
                    GUIUtils.setLoadImages(true);
                    return false;
                }
                SoftwareUpdater.this.paneFetchUpdate.setButtonCancelEnabled(false);
                this.m_iRange = 80;
                this.m_lFileSize = this.m_fileNewJapJar.length();
                try {
                    Util.copyStream(new FileInputStream(this.m_fileNewJapJar), new FileOutputStream(this.m_fileAktJapJar), this);
                }
                catch (SecurityException a_e) {
                    LogHolder.log(4, LogType.MISC, a_e);
                    bWriteProtected = true;
                    this.setValue(620);
                }
                catch (IOException a_e) {
                    LogHolder.log(4, LogType.MISC, a_e);
                    bWriteProtected = true;
                    this.setValue(620);
                }
                if (Thread.currentThread().isInterrupted()) {
                    GUIUtils.setLoadImages(true);
                    return false;
                }
                if (bWriteProtected || !RecursiveFileTool.equals(this.m_fileNewJapJar, this.m_fileAktJapJar, true)) {
                    if (this.m_strTempDirectory == null) {
                        this.m_strTempDirectory = AbstractOS.getInstance().getTempPath();
                        if (this.m_strTempDirectory == null) {
                            throw new Exception("Administrator copy failed!");
                        }
                        File fileTemp = new File(this.m_strTempDirectory + this.m_fileAktJapJar.getName());
                        this.m_iRange = 20;
                        Util.copyStream(new FileInputStream(this.m_fileNewJapJar), new FileOutputStream(fileTemp), this);
                        this.m_fileNewJapJar = fileTemp;
                    }
                    AbstractOS.AbstractRetryCopyProcess retryDialog = new AbstractOS.AbstractRetryCopyProcess(12){

                        public boolean checkRetry() {
                            return JAPDialog.showYesNoDialog(SoftwareUpdater.this.paneFetchUpdate.getContentPane(), JAPMessages.getString(JAPUpdateWizard.MSG_ENTER_ADMIN_PASSWORD));
                        }

                        public boolean incrementProgress() {
                            if (super.incrementProgress()) {
                                UpdateThread.this.setValue(640 + (this.getCurrentStep() + 1) * 5);
                                return true;
                            }
                            return false;
                        }

                        public void reset() {
                            super.reset();
                            UpdateThread.this.setValue(620);
                        }
                    };
                    if (Thread.currentThread().isInterrupted()) {
                        GUIUtils.setLoadImages(true);
                        return false;
                    }
                    boolean copySuccess = AbstractOS.getInstance().copyAsRoot(this.m_fileNewJapJar, new File(this.m_fileAktJapJar.getParent()), retryDialog);
                    if (!copySuccess || !RecursiveFileTool.equals(this.m_fileNewJapJar, this.m_fileAktJapJar, true)) {
                        throw new Exception("Administrator copy failed!");
                    }
                }
                this.m_strMessage = SoftwareUpdater.this.createMessage(5, false);
                this.setValue(700);
                return true;
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, e);
                GUIUtils.setLoadImages(true);
                this.m_strFailedReason = JAPMessages.getString(MSG_ERROR_OVERWRITING_FAILED);
                return false;
            }
        }

        public int getMaximum() {
            return 700;
        }

        public int getMinimum() {
            return 0;
        }

        public int getValue() {
            return this.m_iValue;
        }

        public int getStatus() {
            return this.m_iStatus;
        }

        public void reset() {
        }

        public String getMessage() {
            return this.m_strMessage;
        }
    }
}

