/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.server.ForwardServerManager;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.MixCascade;
import anon.util.XMLUtil;
import jap.JAPModel;
import jap.forward.JAPRoutingMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JAPRoutingUseableMixCascades
extends Observable
implements Observer,
Runnable {
    private static final long MIXCASCADELIST_UPDATE_INTERVAL = 600000L;
    Hashtable m_allowedMixCascades = new Hashtable();
    boolean m_allowAllAvailableCascades = true;
    Hashtable m_currentlyRunningMixCascades = new Hashtable();
    Thread m_updateMixCascadesListThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_notifier, Object a_message) {
        block10: {
            if (a_notifier == JAPModel.getInstance().getRoutingSettings()) {
                try {
                    if (((JAPRoutingMessage)a_message).getMessageCode() != 1) break block10;
                    JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
                    synchronized (jAPRoutingUseableMixCascades) {
                        if (JAPModel.getInstance().getRoutingSettings().getRoutingMode() == 2 || JAPModel.getInstance().getRoutingSettings().getForwarderAddress().getTransportIdentifier().equals("local")) {
                            if (this.m_updateMixCascadesListThread == null) {
                                this.startMixCascadesListUpdateThread();
                            }
                        } else if (this.m_updateMixCascadesListThread != null) {
                            this.stopMixCascadesListUpdateThread();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedMixCascades(Vector a_mixCascades) {
        Object object = this.m_allowedMixCascades;
        synchronized (object) {
            this.m_allowedMixCascades.clear();
            Enumeration newAllowedCascades = a_mixCascades.elements();
            while (newAllowedCascades.hasMoreElements()) {
                MixCascade currentMixCascade = (MixCascade)newAllowedCascades.nextElement();
                this.m_allowedMixCascades.put(currentMixCascade.getId(), currentMixCascade);
            }
        }
        object = this;
        synchronized (object) {
            if (this.m_updateMixCascadesListThread != null && !this.m_allowAllAvailableCascades) {
                this.updateUseableCascadesDatabase();
            }
            this.setChanged();
            this.notifyObservers(new JAPRoutingMessage(10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToAllowedMixCascades(MixCascade a_mixCascade) {
        if (a_mixCascade != null) {
            Object object = this.m_allowedMixCascades;
            synchronized (object) {
                this.m_allowedMixCascades.put(a_mixCascade.getId(), a_mixCascade);
            }
            object = this;
            synchronized (object) {
                if (this.m_updateMixCascadesListThread != null && !this.m_allowAllAvailableCascades) {
                    this.updateUseableCascadesDatabase();
                }
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(10));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromAllowedMixCascades(String a_mixCascadeId) {
        if (a_mixCascadeId != null) {
            boolean cascadeRemoved = false;
            Object object = this.m_allowedMixCascades;
            synchronized (object) {
                if (this.m_allowedMixCascades.remove(a_mixCascadeId) != null) {
                    cascadeRemoved = true;
                }
            }
            if (cascadeRemoved) {
                object = this;
                synchronized (object) {
                    if (this.m_updateMixCascadesListThread != null && !this.m_allowAllAvailableCascades) {
                        this.updateUseableCascadesDatabase();
                    }
                    this.setChanged();
                    this.notifyObservers(new JAPRoutingMessage(10));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllowedMixCascades() {
        Vector resultValue = new Vector();
        Hashtable hashtable = this.m_allowedMixCascades;
        synchronized (hashtable) {
            Enumeration allowedCascades = this.m_allowedMixCascades.elements();
            while (allowedCascades.hasMoreElements()) {
                resultValue.addElement(allowedCascades.nextElement());
            }
        }
        return resultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowAllAvailableMixCascades(boolean a_allowAllAvailableCascades) {
        JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
        synchronized (jAPRoutingUseableMixCascades) {
            if (this.m_allowAllAvailableCascades != a_allowAllAvailableCascades) {
                this.m_allowAllAvailableCascades = a_allowAllAvailableCascades;
                if (this.m_updateMixCascadesListThread != null) {
                    this.updateUseableCascadesDatabase();
                }
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(9));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowAllAvailableMixCascades() {
        boolean returnValue = false;
        JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
        synchronized (jAPRoutingUseableMixCascades) {
            returnValue = this.m_allowAllAvailableCascades;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getSettingsAsXml(Document a_doc) {
        Element allowedMixCascadesSettingsNode = a_doc.createElement("AllowedMixCascadesSettings");
        Element allowAllAvailableMixCascadesNode = a_doc.createElement("AllowAllAvailableMixCascades");
        Element allowedMixCascadesNode = a_doc.createElement("AllowedMixCascades");
        JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
        synchronized (jAPRoutingUseableMixCascades) {
            XMLUtil.setValue((Node)allowAllAvailableMixCascadesNode, this.getAllowAllAvailableMixCascades());
            Enumeration allowedMixCascades = this.getAllowedMixCascades().elements();
            while (allowedMixCascades.hasMoreElements()) {
                allowedMixCascadesNode.appendChild(((MixCascade)allowedMixCascades.nextElement()).toXmlElement(a_doc));
            }
        }
        allowedMixCascadesSettingsNode.appendChild(allowAllAvailableMixCascadesNode);
        allowedMixCascadesSettingsNode.appendChild(allowedMixCascadesNode);
        return allowedMixCascadesSettingsNode;
    }

    public boolean loadSettingsFromXml(Element a_allowedMixCascadesSettingsNode) {
        boolean noError = true;
        Element allowAllAvailableMixCascadesNode = (Element)XMLUtil.getFirstChildByName(a_allowedMixCascadesSettingsNode, "AllowAllAvailableMixCascades");
        if (allowAllAvailableMixCascadesNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingUseableMixCascades: loadSettingsFromXml: Error in XML structure (AllowAllAvailableMixCascades node): Using default setting.");
            noError = false;
        } else {
            this.setAllowAllAvailableMixCascades(XMLUtil.parseValue((Node)allowAllAvailableMixCascadesNode, this.getAllowAllAvailableMixCascades()));
        }
        Element allowedMixCascadesNode = (Element)XMLUtil.getFirstChildByName(a_allowedMixCascadesSettingsNode, "AllowedMixCascades");
        if (allowedMixCascadesNode == null) {
            LogHolder.log(3, LogType.MISC, "Error in XML structure (AllowedMixCascades node): Skip loading of allowed mixcascades.");
            noError = false;
        } else {
            NodeList mixCascadeNodes = allowedMixCascadesNode.getElementsByTagName("MixCascade");
            Vector<MixCascade> allowedMixCascades = new Vector<MixCascade>();
            for (int i = 0; i < mixCascadeNodes.getLength(); ++i) {
                Element mixCascadeNode = (Element)mixCascadeNodes.item(i);
                try {
                    MixCascade currentMixCascade = new MixCascade(mixCascadeNode);
                    allowedMixCascades.addElement(currentMixCascade);
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "Error while loading one allowed MixCascade: Skipping this MixCascade (" + e.toString() + ").");
                    noError = false;
                }
            }
            this.setAllowedMixCascades(allowedMixCascades);
        }
        return noError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean stopThread = false;
        while (!stopThread && !Thread.currentThread().isInterrupted()) {
            Hashtable runningMixCascadesList = InfoServiceHolder.getInstance().getMixCascades();
            if (runningMixCascadesList == null) {
                runningMixCascadesList = new Hashtable();
            }
            Object object = this.m_currentlyRunningMixCascades;
            synchronized (object) {
                this.m_currentlyRunningMixCascades.clear();
                Enumeration runningMixCascades = runningMixCascadesList.elements();
                while (runningMixCascades.hasMoreElements()) {
                    MixCascade currentMixCascade = (MixCascade)runningMixCascades.nextElement();
                    this.m_currentlyRunningMixCascades.put(currentMixCascade.getId(), currentMixCascade);
                }
            }
            this.updateUseableCascadesDatabase();
            object = this.m_updateMixCascadesListThread;
            synchronized (object) {
                stopThread = Thread.interrupted();
                if (!stopThread) {
                    try {
                        this.m_updateMixCascadesListThread.wait(600000L);
                    }
                    catch (Exception e) {
                        stopThread = true;
                    }
                }
            }
        }
        Hashtable hashtable = this.m_currentlyRunningMixCascades;
        synchronized (hashtable) {
            this.m_currentlyRunningMixCascades.clear();
        }
        ForwardServerManager.getInstance().getAllowedCascadesDatabase().removeAllCascades();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUseableCascadesDatabase() {
        Hashtable hashtable = this.m_currentlyRunningMixCascades;
        synchronized (hashtable) {
            Hashtable hashtable2 = this.m_allowedMixCascades;
            synchronized (hashtable2) {
                boolean useAllAvailableCascades = this.m_allowAllAvailableCascades;
                Enumeration runningMixCascades = this.m_currentlyRunningMixCascades.elements();
                while (runningMixCascades.hasMoreElements()) {
                    MixCascade currentMixCascade = (MixCascade)runningMixCascades.nextElement();
                    if (useAllAvailableCascades) {
                        ForwardServerManager.getInstance().getAllowedCascadesDatabase().addCascade(currentMixCascade);
                        continue;
                    }
                    if (!this.m_allowedMixCascades.containsKey(currentMixCascade.getId())) continue;
                    ForwardServerManager.getInstance().getAllowedCascadesDatabase().addCascade(currentMixCascade);
                }
                Enumeration forwardingCascades = ForwardServerManager.getInstance().getAllowedCascadesDatabase().getEntryList().elements();
                while (forwardingCascades.hasMoreElements()) {
                    MixCascade currentForwardingMixCascade = (MixCascade)forwardingCascades.nextElement();
                    if (this.m_currentlyRunningMixCascades.containsKey(currentForwardingMixCascade.getId())) {
                        if (useAllAvailableCascades || this.m_allowedMixCascades.containsKey(currentForwardingMixCascade.getId())) continue;
                        ForwardServerManager.getInstance().getAllowedCascadesDatabase().removeCascade(currentForwardingMixCascade.getId());
                        continue;
                    }
                    ForwardServerManager.getInstance().getAllowedCascadesDatabase().removeCascade(currentForwardingMixCascade.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMixCascadesListUpdateThread() {
        JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
        synchronized (jAPRoutingUseableMixCascades) {
            if (this.m_updateMixCascadesListThread == null) {
                LogHolder.log(6, LogType.MISC, "JAPRoutingUseableMixCascades: startMixCascadesListUpdateThread: The mixcascade management thread of the forwarding server is started.");
                this.m_updateMixCascadesListThread = new Thread(this);
                this.m_updateMixCascadesListThread.setDaemon(true);
                this.m_updateMixCascadesListThread.start();
            } else {
                LogHolder.log(6, LogType.MISC, "JAPRoutingUseableMixCascades: startMixCascadesListUpdateThread: The mixcascade management thread of the forwarding server was already started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMixCascadesListUpdateThread() {
        LogHolder.log(6, LogType.MISC, "JAPRoutingUseableMixCascades: stopMixCascadesListUpdateThread: Shutdown the mixcascade management thread of the forwarding server...");
        JAPRoutingUseableMixCascades jAPRoutingUseableMixCascades = this;
        synchronized (jAPRoutingUseableMixCascades) {
            if (this.m_updateMixCascadesListThread != null) {
                Thread thread = this.m_updateMixCascadesListThread;
                synchronized (thread) {
                    this.m_updateMixCascadesListThread.interrupt();
                }
                try {
                    this.m_updateMixCascadesListThread.join();
                    LogHolder.log(6, LogType.MISC, "JAPRoutingUseableMixCascades: stopMixCascadesListUpdateThread: Mixcascade management thread of the forwarding server halted.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_updateMixCascadesListThread = null;
            } else {
                LogHolder.log(6, LogType.MISC, "JAPRoutingUseableMixCascades: stopMixCascadesListUpdateThread: The mixcascade management thread of the forwarding server was not running.");
            }
        }
    }
}

