/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionTableModel;
import mixconfig.network.OutgoingConnectionTableModel;
import mixconfig.network.OutgoingDialog;
import mixconfig.network.ProxyTableModel;
import mixconfig.panels.CertPanel;
import mixconfig.panels.OtherMixPanel;

public final class NextMixProxyPanel
extends OtherMixPanel
implements TableModelListener,
ActionListener,
ChangeListener,
ComponentListener {
    private JPanel m_panel;
    private JTable m_table;
    private ConnectionTableModel m_model;
    private JButton m_bttnAdd;
    private TitledBorder m_border;

    public NextMixProxyPanel() {
        super("Next Mix");
        this.addComponentListener(this);
        GridBagLayout Out_Layout = super.getGridBagLayout();
        GridBagConstraints c = super.getGridBagConstraints();
        final DefaultTableCellRenderer portRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                int t = (Integer)v;
                if (t <= 0) {
                    super.setValue("");
                } else {
                    this.setHorizontalAlignment(0);
                    super.setValue(v.toString());
                }
            }
        };
        final DefaultTableCellRenderer transportRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                int t = (Integer)v;
                super.setValue(((t & 2) == 0 ? "Raw/" : "SSL/") + ((t & 1) == 0 ? "TCP" : "Unix"));
                this.setHorizontalAlignment(0);
            }
        };
        final DefaultTableCellRenderer centeringRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                super.setValue(v);
                this.setHorizontalAlignment(0);
            }
        };
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 3;
        constraints.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.m_panel = new JPanel(Out_Layout);
        this.m_border = new TitledBorder("Outgoing");
        this.m_panel.setBorder(this.m_border);
        this.m_panel.setToolTipText("Connection(s) to next Mix or Proxies.");
        this.add((Component)this.m_panel, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JLabel(" "), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_model = new OutgoingConnectionTableModel();
        this.m_model.addTableModelListener(this);
        this.m_table = new JTable(this.m_model){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                switch (column) {
                    case 1: {
                        return centeringRenderer;
                    }
                    case 2: {
                        return transportRenderer;
                    }
                    case 4: {
                        return portRenderer;
                    }
                }
                return centeringRenderer;
            }
        };
        JScrollPane scrollPane2 = new JScrollPane(this.m_table, 22, 30);
        this.m_table.setName("Network");
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setSelectionMode(0);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(500, 40));
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String title = (NextMixProxyPanel.this.getConfiguration().getMixType() & 4) > 0 ? "Proxy" : "Next Mix";
                    new OutgoingDialog(MixConfig.getMainWindow(), "Change" + title, NextMixProxyPanel.this.m_model, NextMixProxyPanel.this.m_model.getData(NextMixProxyPanel.this.m_table.getSelectedRow())).setVisible(true);
                }
            }
        });
        this.setColumnSizes();
        constraints.anchor = 17;
        constraints.insets = this.getDefaultInsets();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 3;
        constraints.fill = 2;
        this.m_panel.add((Component)scrollPane2, constraints);
        int i = 0;
        while (i < 2) {
            JButton button;
            switch (i) {
                case 0: {
                    button = new JButton("Add");
                    button.setActionCommand("Add");
                    button.addActionListener(this);
                    this.m_bttnAdd = button;
                    break;
                }
                case 1: {
                    button = new JButton("Delete");
                    this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            button.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
                        }
                    });
                    button.setEnabled(false);
                    button.setActionCommand("Delete");
                    button.addActionListener(this);
                    break;
                }
                default: {
                    throw new RuntimeException("Creating unknown button");
                }
            }
            GridBagConstraints ibd = new GridBagConstraints();
            ibd.anchor = 18;
            ibd.insets = this.getDefaultInsets();
            ibd.gridx = 1;
            ibd.gridy = i++;
            ibd.weightx = 0.1;
            ibd.weighty = 0.2;
            ibd.fill = 2;
            Out_Layout.setConstraints(button, ibd);
            this.m_panel.add(button);
        }
        constraints.fill = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(), constraints);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.enableComponents();
        if (this.isAutoSaveEnabled() && e.getSource() == this.m_table.getModel()) {
            this.save(this.m_table);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            if (e.getSource() instanceof JTextField) {
                super.focusLost(e);
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
        this.enableComponents();
    }

    @Override
    public Vector<String> check() {
        Vector<String> errors = super.check();
        int mixType = MixConfig.getMixConfiguration().getMixType();
        if (this.m_model.getRowCount() == 0) {
            if (mixType == 4 || !this.getConfiguration().isAutoConfigurationAllowed()) {
                errors.addElement("You must specify outgoing connections in " + this.getName() + " panel.");
            }
        } else {
            int rows = this.m_model.getRowCount();
            for (int i = 0; i < rows; ++i) {
                ConnectionData data = this.m_model.getData(i);
                if ((data.getTransport() & 1) == 0) {
                    if (data.getHostname() == null || data.getHostname().length() == 0) {
                        errors.addElement("Outgoing connection no. " + (i + 1) + " has no host name set.");
                    }
                    if (data.getPort() != 0) continue;
                    errors.addElement("Outgoing connection no. " + (i + 1) + " has no port set.");
                    continue;
                }
                if (data.getHostname() != null && data.getHostname().length() != 0) continue;
                errors.addElement("Outgoing connection no. " + (i + 1) + " has no filename set.");
            }
            if (mixType != 4 && this.m_model.getRowCount() > 1) {
                errors.addElement("Too many outgoing connections in panel NextMix.");
            }
        }
        return errors;
    }

    @Override
    protected void enableComponents() {
        try {
            int mixType = this.getConfiguration().getMixType();
            if (mixType == 4) {
                this.getMixCertPanel().removeCert();
                this.m_border.setTitle("Proxy");
            } else {
                this.m_border.setTitle("Next Mix");
            }
            boolean bEnableCerts = mixType != 4 && (!this.getConfiguration().isAutoConfigurationAllowed() || this.getConfiguration().isFallbackEnabled());
            this.getMixCertPanel().setEnabled(bEnableCerts);
            this.getLocationPanel().setEnabled(bEnableCerts);
            this.getOperatorPanel().setEnabled(bEnableCerts);
            this.getMixOperatorCertPanel().setEnabled(bEnableCerts);
            this.getMixCertPanel().setVisible(bEnableCerts);
            this.getLocationPanel().setVisible(bEnableCerts);
            this.getOperatorPanel().setVisible(bEnableCerts);
            this.getMixOperatorCertPanel().setVisible(bEnableCerts);
            boolean bEnableOutgoing = mixType == 4 || !this.getConfiguration().isAutoConfigurationAllowed() || this.getConfiguration().isFallbackEnabled();
            this.m_bttnAdd.setEnabled(mixType == 4 || this.m_model.getRowCount() == 0);
            this.m_table.setEnabled(bEnableOutgoing);
            this.setEnabled(bEnableOutgoing);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.addChangeListener(this);
        this.setEnabled(this.getConfiguration().getMixType() != 4);
        this.enableComponents();
    }

    @Override
    public void load() throws IOException {
        this.resetTableModel();
        super.load();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e instanceof ConfigurationEvent) {
                ConfigurationEvent c = (ConfigurationEvent)e;
                if (c.getModifiedXMLPath().equals("General/MixType")) {
                    for (int i = 0; i >= 0 && i < this.m_model.getRowCount(); ++i) {
                        int flags = this.m_model.getData(i).getFlags();
                        if (this.getConfiguration().getMixType() == 4) {
                            if (flags != 0) continue;
                            this.m_model.deleteData(i);
                            --i;
                            continue;
                        }
                        if (flags <= 0) continue;
                        this.m_model.deleteData(i);
                        --i;
                    }
                    this.enableComponents();
                    this.resetTableModel();
                } else if (c.getModifiedXMLPath().indexOf("Network/InfoService/AllowAutoConfiguration") >= 0) {
                    this.enableComponents();
                }
            } else if (e.getSource() instanceof CertPanel) {
                this.save((CertPanel)e.getSource());
            }
            super.stateChanged(e);
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        String title = (this.getConfiguration().getMixType() & 4) > 0 ? "Proxy" : "Next Mix";
        if (a.getActionCommand().equals("Add")) {
            new OutgoingDialog(MixConfig.getMainWindow(), "Add " + title, this.m_model).setVisible(true);
        } else if (a.getActionCommand().equals("Delete")) {
            this.m_model.deleteData(this.m_table.getSelectedRow());
        }
    }

    private void resetTableModel() {
        this.m_model = this.createTableModel();
        this.m_table.setModel(this.m_model);
        this.m_model.addTableModelListener(this);
        this.setColumnSizes();
    }

    private ConnectionTableModel createTableModel() {
        int mixType = this.getConfiguration().getMixType();
        ConnectionTableModel ret = mixType == 4 ? new ProxyTableModel() : new OutgoingConnectionTableModel();
        return ret;
    }

    private void setColumnSizes() {
        if (this.m_model instanceof ProxyTableModel) {
            int[] columnSizes = new int[]{15, 35, 55, 100, 40, 100};
            this.adjustColumnSizes(columnSizes);
        } else {
            int[] columnSizes = new int[]{15, 35, 55, 195, 40};
            this.adjustColumnSizes(columnSizes);
        }
    }

    private void adjustColumnSizes(int[] columnSizes) {
        for (int i = 0; i < columnSizes.length; ++i) {
            TableColumn column = this.m_table.getColumnModel().getColumn(i);
            column.setPreferredWidth(columnSizes[i]);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        MixConfiguration m = this.getConfiguration();
        if (m.isMixOnCDEnabled() && m.getMixType() == 4 && this.m_table.getRowCount() == 0) {
            ConnectionData c = new ConnectionData("Proxy", 0, "localhost", 8080, 1, false, false);
            this.m_model.addData(c);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

