/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractChannel;
import anon.client.AbstractDataChain;
import anon.client.DataChainSendOrderStructure;
import anon.client.InternalChannelMessageQueue;
import anon.client.MixPacket;
import anon.client.Multiplexer;
import anon.client.crypto.MixCipherChain;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractDataChannel
extends AbstractChannel {
    private static final short FLAG_CHANNEL_DUMMY = 16;
    private MixCipherChain m_mixCipherChain;
    private AbstractDataChain m_parentDataChain;
    private InternalChannelMessageQueue m_channelMessageQueue;

    public AbstractDataChannel(int n, Multiplexer multiplexer, AbstractDataChain abstractDataChain, MixCipherChain mixCipherChain) {
        super(n, multiplexer);
        this.m_parentDataChain = abstractDataChain;
        this.m_mixCipherChain = mixCipherChain;
        this.m_channelMessageQueue = new InternalChannelMessageQueue();
    }

    public InternalChannelMessageQueue getChannelMessageQueue() {
        return this.m_channelMessageQueue;
    }

    public void processReceivedPacket(MixPacket mixPacket) {
        this.m_mixCipherChain.decryptPacket(mixPacket.getPayloadData());
        if ((mixPacket.getChannelFlags() & 0x10) == 16) {
            LogHolder.log(6, LogType.NET, "AbstractDataChannel: processReceivedPacket(): Catched an unexpected dummy-paket on channel '" + Integer.toString(mixPacket.getChannelId()) + "'.");
        } else {
            this.handleReceivedPacket(mixPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextPacketRecommandedOutputBlocksize() {
        int n = 0;
        MixCipherChain mixCipherChain = this.m_mixCipherChain;
        synchronized (mixCipherChain) {
            n = MixPacket.getPayloadSize() - this.m_mixCipherChain.getNextPacketEncryptionOverhead();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndSendMixPacket(DataChainSendOrderStructure dataChainSendOrderStructure, short s) {
        MixPacket mixPacket = this.createEmptyMixPacket();
        mixPacket.setChannelFlags(s);
        MixCipherChain mixCipherChain = this.m_mixCipherChain;
        synchronized (mixCipherChain) {
            dataChainSendOrderStructure.setChannelCell(new byte[mixPacket.getPayloadData().length - this.m_mixCipherChain.getNextPacketEncryptionOverhead()]);
            System.arraycopy(mixPacket.getPayloadData(), mixPacket.getPayloadData().length - dataChainSendOrderStructure.getChannelCell().length, dataChainSendOrderStructure.getChannelCell(), 0, dataChainSendOrderStructure.getChannelCell().length);
            if (dataChainSendOrderStructure.getOrderData() != null) {
                this.m_parentDataChain.createPacketPayload(dataChainSendOrderStructure);
            }
            byte[] byArray = this.m_mixCipherChain.encryptPacket(dataChainSendOrderStructure.getChannelCell(), mixPacket.getPayloadData().length, mixPacket.getSendCallbackHandlers());
            System.arraycopy(byArray, 0, mixPacket.getPayloadData(), 0, mixPacket.getPayloadData().length);
            try {
                this.sendPacket(mixPacket);
            }
            catch (IOException iOException) {
                dataChainSendOrderStructure.setThrownException(iOException);
            }
        }
        dataChainSendOrderStructure.processingDone();
    }

    public abstract boolean processSendOrder(DataChainSendOrderStructure var1);

    public abstract void organizeChannelClose() throws IOException;

    protected abstract void handleReceivedPacket(MixPacket var1);
}

