/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.pay.xml.XMLDescription;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.w3c.dom.Document;

public final class HttpClient {
    private BufferedReader m_reader;
    private BufferedOutputStream m_OS;
    private Socket m_socket;

    public HttpClient(Socket socket) throws IOException {
        this.m_socket = socket;
        this.m_reader = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream()));
        this.m_OS = new BufferedOutputStream(this.m_socket.getOutputStream(), 4096);
    }

    public void close() throws IOException, XMLParseException {
        this.writeRequest("GET", "close", null);
        this.readAnswer();
        if (this.m_socket != null) {
            this.m_socket.close();
        }
    }

    public void writeRequest(String string, String string2, String string3) throws IOException {
        this.m_OS.write((string + " /" + string2 + " HTTP/1.1\r\n").getBytes());
        if (string.equals("POST")) {
            this.m_OS.write(("Content-Length: " + string3.length() + "\r\n").getBytes());
            this.m_OS.write("\r\n".getBytes());
            this.m_OS.write(string3.getBytes());
        } else {
            this.m_OS.write("\r\n".getBytes());
        }
        this.m_OS.flush();
    }

    public Document readAnswer() throws IOException, XMLParseException {
        int n = -1;
        char[] cArray = null;
        String string = this.m_reader.readLine();
        if (string == null) {
            throw new IOException("No answer received");
        }
        int n2 = string.indexOf(" ");
        if (n2 == -1) {
            throw new IOException("Wrong Header");
        }
        if ((n2 = (string = string.substring(n2 + 1)).indexOf(" ")) == -1) {
            throw new IOException("Wrong Header");
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        string = this.m_reader.readLine();
        while (string != null && !string.equals("")) {
            n2 = string.indexOf(" ");
            if (n2 == -1) {
                throw new IOException("Wrong Header: " + string);
            }
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1).trim();
            if (string4.equalsIgnoreCase("Content-length:")) {
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Error: received invalid value for header Content-length: " + string5);
                }
            }
            string = this.m_reader.readLine();
        }
        if (n > 0) {
            cArray = new char[n];
            int n3 = 0;
            int n4 = 0;
            while ((n4 = this.m_reader.read(cArray, n3, n - n3)) != -1 && (n3 += n4) < n) {
            }
        }
        if (!string2.equals("200")) {
            if (string2.equals("409")) {
                String string6;
                try {
                    XMLDescription xMLDescription = new XMLDescription(cArray);
                    string6 = xMLDescription.getDescription();
                }
                catch (Exception exception) {
                    string6 = "Unkown Error";
                }
                throw new IOException(string6);
            }
            throw new IOException(string3);
        }
        return XMLUtil.toXMLDocument(cArray);
    }
}

