/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.client.PacketCounter;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.XMLEncryption;
import anon.pay.BIConnection;
import anon.pay.IAccountListener;
import anon.pay.IMessageListener;
import anon.pay.PayAccountsFile;
import anon.pay.PayMessage;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLAccountCertificate;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLEasyCC;
import anon.pay.xml.XMLGenericStrings;
import anon.pay.xml.XMLGenericText;
import anon.pay.xml.XMLTransCert;
import anon.util.Base64;
import anon.util.IMiscPasswordReader;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PayAccount
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "Account";
    private static final String XML_ATTR_ACTIVE = "active";
    private static final String XML_BACKUP_DONE = "backupDone";
    public static final long ACCOUNT_MIN_UPDATE_INTERVAL_MS = 60000L;
    public static final long ACCOUNT_MAX_UPDATE_INTERVAL_MS = 300000L;
    private final Object SYNC_BYTES = new Object();
    private static final long NEW_ACCOUNT_EXPIRATION_TIME = 604800000L;
    private static final String VERSION = "1.1";
    private Vector m_transCerts;
    private XMLAccountCertificate m_accountCertificate;
    private XMLAccountInfo m_accountInfo;
    private XMLGenericText m_terms;
    private IMyPrivateKey m_privateKey;
    private Document m_encryptedPrivateKey;
    private long m_currentBytes;
    private Vector m_accountListeners = new Vector();
    private Vector m_messageListeners = new Vector();
    private long m_lBackupDone = 0L;
    private long m_lastAccountInfoUpdate = 0L;
    private boolean m_bAccountInfoUpdateRunning = false;
    private Calendar m_termsDate;
    private static final long TRANSACTION_EXPIRATION = 1209600000L;
    public static final int MAX_KBYTES_COUNTING_AS_EMPTY = 5000;
    private long m_mySpent;
    private PaymentInstanceDBEntry m_theBI;
    private String m_strBiID;

    public boolean isTransactionExpired() {
        Timestamp timestamp = this.getCreationTime();
        long l = ((Date)timestamp).getTime();
        Timestamp timestamp2 = new Timestamp(System.currentTimeMillis());
        long l2 = ((Date)timestamp2).getTime();
        long l3 = l2 - l;
        return l3 > 1209600000L;
    }

    public PayAccount(Element element, IMiscPasswordReader iMiscPasswordReader) throws Exception {
        this.setValues(element, iMiscPasswordReader);
    }

    public PayAccount(XMLAccountCertificate xMLAccountCertificate, IMyPrivateKey iMyPrivateKey, PaymentInstanceDBEntry paymentInstanceDBEntry, XMLGenericText xMLGenericText) {
        this.m_accountCertificate = xMLAccountCertificate;
        this.m_privateKey = iMyPrivateKey;
        this.m_transCerts = new Vector();
        this.m_theBI = paymentInstanceDBEntry;
        this.m_strBiID = paymentInstanceDBEntry.getId();
        this.setTerms(xMLGenericText);
    }

    private void setValues(Element element, IMiscPasswordReader iMiscPasswordReader) throws Exception {
        Object object;
        Element element2;
        XMLUtil.assertNodeName(element, XML_ELEMENT_NAME);
        boolean bl = XMLUtil.parseAttribute((Node)element, XML_ATTR_ACTIVE, true);
        boolean bl2 = XMLUtil.parseAttribute((Node)element, XML_BACKUP_DONE, false);
        this.m_lBackupDone = bl2 ? System.currentTimeMillis() : XMLUtil.parseAttribute((Node)element, XML_BACKUP_DONE, 0L);
        this.m_transCerts = new Vector();
        Element element3 = (Element)XMLUtil.getFirstChildByName(element, "TransferCertificates");
        Element element4 = (Element)XMLUtil.getFirstChildByName(element3, "TransferCertificate");
        while (element4 != null) {
            this.m_transCerts.addElement(new XMLTransCert(element4));
            element4 = (Element)XMLUtil.getNextSiblingByName(element4, "TransferCertificate");
        }
        Element element5 = (Element)XMLUtil.getFirstChildByName(element, "AccountCertificate");
        this.m_accountCertificate = new XMLAccountCertificate(element5);
        Element element6 = (Element)XMLUtil.getFirstChildByName(element, "AccountInfo");
        if (element6 != null) {
            this.m_accountInfo = new XMLAccountInfo(element6);
        }
        if ((element2 = (Element)XMLUtil.getFirstChildByName(element, "GenericText")) != null && XMLUtil.getStorageMode() != 2) {
            object = new XMLGenericText(element2);
            try {
                byte[] byArray = Base64.decode(((XMLGenericText)object).getText());
                object = new XMLGenericText(new String(ZLibTools.decompress(byArray)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setTerms((XMLGenericText)object);
        }
        object = (Element)XMLUtil.getFirstChildByName(element5, "BiID");
        this.m_strBiID = XMLUtil.parseValue((Node)object, "-1");
        this.m_theBI = null;
        this.decryptPrivateKey(element, iMiscPasswordReader, !bl);
    }

    public Element toXmlElement(Document document) {
        return this.toXmlElement(document, null);
    }

    public Element toXmlElement(Document document, String string) {
        try {
            Object object;
            Object object2;
            if (string != null && string.trim().equals("")) {
                return this.toXmlElement(document, null);
            }
            Element element = document.createElement(XML_ELEMENT_NAME);
            element.setAttribute("version", VERSION);
            Element element2 = this.m_accountCertificate.toXmlElement(document);
            element.appendChild(element2);
            XMLUtil.setAttribute(element, XML_BACKUP_DONE, this.m_lBackupDone);
            if (this.m_encryptedPrivateKey != null) {
                XMLUtil.setAttribute(element, XML_ATTR_ACTIVE, false);
                element2 = (Element)XMLUtil.importNode(document, this.m_encryptedPrivateKey.getDocumentElement(), true);
                element.appendChild(element2);
            } else {
                XMLUtil.setAttribute(element, XML_ATTR_ACTIVE, true);
                element2 = this.m_privateKey.toXmlElement(document);
                element.appendChild(element2);
                if (string != null) {
                    try {
                        XMLEncryption.encryptElement(element2, string);
                    }
                    catch (Exception exception) {
                        LogHolder.log(2, LogType.PAY, "Could not encrypt account key: " + exception);
                    }
                }
            }
            Element element3 = document.createElement("TransferCertificates");
            element.appendChild(element3);
            if (this.m_transCerts != null) {
                object2 = this.m_transCerts.elements();
                while (object2.hasMoreElements()) {
                    object = (XMLTransCert)object2.nextElement();
                    element3.appendChild(((XMLTransCert)object).toXmlElement(document));
                }
            }
            if (this.m_accountInfo != null) {
                element2 = this.m_accountInfo.toXmlElement(document);
                element.appendChild(element2);
            }
            if (this.m_terms != null) {
                object2 = this.m_terms.getText();
                object = Base64.encode(ZLibTools.compress(((String)object2).getBytes()), true);
                XMLGenericText xMLGenericText = new XMLGenericText((String)object);
                element2 = xMLGenericText.toXmlElement(document);
                element.appendChild(element2);
            }
            return element;
        }
        catch (Exception exception) {
            LogHolder.log(2, LogType.PAY, "Exception while creating PayAccount XML: " + exception);
            return null;
        }
    }

    public void addTransCert(XMLTransCert xMLTransCert) throws Exception {
        this.m_transCerts.addElement(xMLTransCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccountInfo(XMLAccountInfo xMLAccountInfo) throws Exception {
        boolean bl = false;
        if (this.m_accountInfo == null) {
            this.m_accountInfo = xMLAccountInfo;
            bl = true;
        } else {
            XMLAccountInfo xMLAccountInfo2 = this.m_accountInfo;
            synchronized (xMLAccountInfo2) {
                String string;
                XMLBalance xMLBalance = xMLAccountInfo.getBalance();
                XMLBalance xMLBalance2 = this.m_accountInfo.getBalance();
                PayMessage payMessage = xMLBalance2.getMessage();
                PayMessage payMessage2 = xMLBalance.getMessage();
                if (xMLBalance.getTimestamp().after(xMLBalance2.getTimestamp())) {
                    this.m_accountInfo.setBalance(xMLBalance);
                    bl = true;
                    if (payMessage2 != null && !payMessage2.getShortMessage().equals("")) {
                        if (payMessage == null) {
                            this.fireMessageReceived(payMessage2);
                        } else if (!payMessage2.equals(payMessage)) {
                            this.fireMessageRemoved(payMessage);
                            this.fireMessageReceived(payMessage2);
                        }
                    } else if (payMessage != null && !payMessage.getShortMessage().equals("")) {
                        this.fireMessageRemoved(payMessage);
                    }
                }
                xMLBalance2.setMessage(payMessage2);
                Enumeration[] enumerationArray = new Enumeration[]{this.m_accountInfo.getCCs(), xMLAccountInfo.getCCs()};
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                for (int i = 0; i < enumerationArray.length; ++i) {
                    while (enumerationArray[i].hasMoreElements()) {
                        string = ((XMLEasyCC)enumerationArray[i].nextElement()).getConcatenatedPriceCertHashes();
                        hashtable.put(string, string);
                    }
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    XMLEasyCC xMLEasyCC = this.m_accountInfo.getCC(string);
                    XMLEasyCC xMLEasyCC2 = xMLAccountInfo.getCC(string);
                    if (xMLEasyCC == null && xMLEasyCC2 == null) {
                        throw new NullPointerException("no CC available for " + string + " This must NEVER happen!");
                    }
                    if (xMLEasyCC2 == null || xMLEasyCC != null && xMLEasyCC2.getTransferredBytes() <= xMLEasyCC.getTransferredBytes()) continue;
                    if (xMLEasyCC2.verify(this.m_accountCertificate.getPublicKey())) {
                        this.addCostConfirmation(xMLEasyCC2);
                        bl = false;
                        continue;
                    }
                    throw new Exception("The BI is trying to betray you with faked CostConfirmations");
                }
            }
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PayAccount)) {
            return false;
        }
        PayAccount payAccount = (PayAccount)object;
        return payAccount.getAccountNumber() == this.getAccountNumber() && (payAccount.m_strBiID == this.m_strBiID || payAccount.m_strBiID != null && this.m_strBiID != null && payAccount.m_strBiID.equals(this.m_strBiID));
    }

    public int hashCode() {
        return (this.getAccountNumber() + this.m_strBiID).hashCode();
    }

    public long getAccountNumber() {
        return this.m_accountCertificate.getAccountNumber();
    }

    public boolean hasExpired() {
        return this.hasExpired(new Timestamp(System.currentTimeMillis()));
    }

    public boolean hasExpired(Timestamp timestamp) {
        XMLBalance xMLBalance = this.getBalance();
        if (xMLBalance != null && (this.getCurrentCredit() > 0L || this.getCurrentSpent() > 0L) && xMLBalance.getFlatEnddate() != null && xMLBalance.getFlatEnddate().before(timestamp)) {
            return true;
        }
        return this.getCreationTime().before(new Date(System.currentTimeMillis() - 604800000L));
    }

    public boolean isCharged(Timestamp timestamp) {
        XMLBalance xMLBalance = this.getBalance();
        if (xMLBalance == null) {
            return false;
        }
        return this.getCurrentCredit() > 0L && xMLBalance.getFlatEnddate() != null && xMLBalance.getFlatEnddate().after(timestamp);
    }

    public boolean isBackupDone() {
        return this.m_lBackupDone > 0L;
    }

    public long getBackupTime() {
        return this.m_lBackupDone;
    }

    public void setBackupDone(long l) {
        this.m_lBackupDone = l;
    }

    public boolean hasAccountInfo() {
        return this.m_accountInfo != null;
    }

    public XMLAccountCertificate getAccountCertificate() {
        return this.m_accountCertificate;
    }

    public Timestamp getCreationTime() {
        return this.m_accountCertificate.getCreationTime();
    }

    public Timestamp getBalanceValidTime() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getValidTime();
        }
        return this.m_accountCertificate.getCreationTime();
    }

    public IMyPrivateKey getPrivateKey() {
        return this.m_privateKey;
    }

    public IMyPublicKey getPublicKey() {
        return this.m_accountCertificate.getPublicKey();
    }

    public long getSpent() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getSpent();
        }
        return 0L;
    }

    public long getDeposit() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getDeposit();
        }
        return 0L;
    }

    public long getCurrentCreditCalculated() {
        if (this.m_accountInfo == null) {
            return Long.MIN_VALUE;
        }
        long l = this.getCurrentCreditCalculatedAlsoNegative();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentCreditCalculatedAlsoNegative() {
        long l;
        if (this.m_accountInfo == null) {
            return Long.MIN_VALUE;
        }
        XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
        synchronized (xMLAccountInfo) {
            l = this.m_accountInfo.getBalance().getSpent() + this.m_accountInfo.getBalance().getVolumeKBytesLeft() * 1000L - this.m_accountInfo.getAllCCsTransferredBytes();
        }
        return l;
    }

    public long getCurrentCreditFromBalance() {
        return this.getBalance().getVolumeKBytesLeft() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentCredit() {
        if (this.m_accountInfo != null) {
            XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
            synchronized (xMLAccountInfo) {
                long l = this.getCurrentCreditCalculated() / 1000L;
                if (l < 0L || l > this.getBalance().getVolumeKBytesLeft()) {
                    return this.getBalance().getVolumeKBytesLeft();
                }
                return l;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentSpent() {
        if (this.m_accountInfo != null) {
            XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
            synchronized (xMLAccountInfo) {
                return this.m_accountInfo.getBalance().getSpent() + this.m_accountInfo.getBalance().getVolumeKBytesLeft() * 1000L - this.getCurrentCredit() * 1000L;
            }
        }
        return 0L;
    }

    public XMLAccountInfo getAccountInfo() {
        return this.m_accountInfo;
    }

    public XMLGenericText getTerms() {
        return this.m_terms;
    }

    public void setTerms(XMLGenericText xMLGenericText) {
        this.m_termsDate = null;
        if (xMLGenericText == null) {
            this.m_terms = null;
        }
        String string = null;
        if (xMLGenericText != null) {
            string = xMLGenericText.getText();
        }
        if (string == null || string.trim().equals("")) {
            this.m_terms = null;
        } else {
            this.m_terms = xMLGenericText;
            int n = string.indexOf("<title>");
            int n2 = string.indexOf("</title>");
            if (n >= 0 && n2 >= 0) {
                try {
                    String string2 = string.substring(n + "<title>".length(), n2);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(string2));
                    this.m_termsDate = calendar;
                }
                catch (ParseException parseException) {
                    LogHolder.log(4, LogType.PAY, parseException);
                    this.m_terms = null;
                }
            } else {
                LogHolder.log(4, LogType.PAY, "No valid title tag was found!");
                this.m_terms = null;
            }
        }
    }

    public Calendar getTermsDate() {
        return this.m_termsDate;
    }

    public Vector getTransCerts() {
        return this.m_transCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateCurrentBytes(PacketCounter packetCounter) throws Exception {
        long l;
        if (PayAccountsFile.getInstance().getActiveAccount() != this) {
            throw new Exception("Error: Inactive account called to count used bytes!");
        }
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            l = packetCounter.getAndResetBytesForPayment();
            if (l > 0L) {
                this.m_currentBytes += l;
            }
        }
        if (l > 0L) {
            this.fireChangeEvent();
        } else if (l < 0L) {
            throw new Exception("Negative payment bytes added! Bytes: " + l);
        }
        return l;
    }

    public void resetCurrentBytes() {
        this.m_currentBytes = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCurrentBytes(long l) {
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            this.m_currentBytes += l;
        }
    }

    public long getCurrentBytes() {
        return this.m_currentBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addCostConfirmation(XMLEasyCC xMLEasyCC) throws Exception {
        long l;
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            if (this.m_accountInfo == null) {
                this.m_accountInfo = new XMLAccountInfo();
            }
            if ((l = this.m_accountInfo.addCC(xMLEasyCC)) > 0L) {
                this.m_mySpent += l;
            }
        }
        this.fireChangeEvent();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccountListener(IAccountListener iAccountListener) {
        Vector vector = this.m_accountListeners;
        synchronized (vector) {
            if (iAccountListener != null) {
                this.m_accountListeners.addElement(iAccountListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IMessageListener iMessageListener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            if (iMessageListener != null) {
                this.m_messageListeners.addElement(iMessageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(IMessageListener iMessageListener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            this.m_messageListeners.removeElement(iMessageListener);
        }
    }

    private void fireChangeEvent() {
        Enumeration enumeration = ((Vector)this.m_accountListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IAccountListener)enumeration.nextElement()).accountChanged(this);
        }
    }

    private void fireMessageReceived(PayMessage payMessage) {
        Enumeration enumeration = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IMessageListener)enumeration.nextElement()).messageReceived(payMessage);
        }
    }

    private void fireMessageRemoved(PayMessage payMessage) {
        Enumeration enumeration = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IMessageListener)enumeration.nextElement()).messageRemoved(payMessage);
        }
    }

    public XMLBalance getBalance() {
        if (this.m_accountInfo == null) {
            return null;
        }
        return this.m_accountInfo.getBalance();
    }

    public boolean isFlatrateActive() {
        boolean bl = false;
        XMLBalance xMLBalance = this.m_accountInfo.getBalance();
        Timestamp timestamp = xMLBalance.getFlatEnddate();
        Timestamp timestamp2 = new Timestamp(System.currentTimeMillis());
        long l = this.getCurrentCredit();
        if (timestamp != null && timestamp.after(timestamp2) && l > 0L) {
            bl = true;
        }
        return bl;
    }

    public void fetchAccountInfo(boolean bl) throws SecurityException, Exception {
        this.fetchAccountInfo(bl, 0);
    }

    public void fetchAccountInfo(boolean bl, int n) throws SecurityException, Exception {
        if (!(bl || PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled() && !this.m_bAccountInfoUpdateRunning)) {
            return;
        }
        if (this.getPrivateKey() == null) {
            throw new SecurityException("Account is encrypted and not usable!");
        }
        XMLAccountInfo xMLAccountInfo = null;
        this.m_theBI = this.getBI();
        if (this.m_theBI == null) {
            return;
        }
        BIConnection bIConnection = null;
        this.m_bAccountInfoUpdateRunning = true;
        try {
            bIConnection = new BIConnection(this.m_theBI);
            if (n > 0) {
                bIConnection.connect(n);
            } else {
                bIConnection.connect();
            }
            bIConnection.authenticate(this.m_accountCertificate, this.m_privateKey);
            xMLAccountInfo = bIConnection.getAccountInfo();
            bIConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                bIConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.m_bAccountInfoUpdateRunning = false;
            throw exception;
        }
        this.m_bAccountInfoUpdateRunning = false;
        if (xMLAccountInfo != null) {
            this.m_lastAccountInfoUpdate = System.currentTimeMillis();
            this.setAccountInfo(xMLAccountInfo);
            this.fireChangeEvent();
        }
    }

    public boolean isAccountInfoUpdated() {
        return this.m_lastAccountInfoUpdate > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldUpdateAccountInfo() {
        if (!PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled() || this.m_bAccountInfoUpdateRunning) {
            return false;
        }
        long l = PayAccountsFile.getInstance().getActiveAccount() == this ? 60000L : 300000L;
        if (this.m_lastAccountInfoUpdate == 0L) {
            if (this.m_accountInfo == null) {
                return true;
            }
            XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
            synchronized (xMLAccountInfo) {
                if (this.m_accountInfo.getBalance() == null || this.m_accountInfo.getBalance().getTimestamp() == null || ((Date)this.m_accountInfo.getBalance().getTimestamp()).getTime() > System.currentTimeMillis() || ((Date)this.m_accountInfo.getBalance().getTimestamp()).getTime() < System.currentTimeMillis() - l) {
                    return true;
                }
            }
        } else if (this.m_lastAccountInfoUpdate < System.currentTimeMillis() - l) {
            return true;
        }
        return false;
    }

    public XMLTransCert charge(XMLGenericStrings xMLGenericStrings) throws SecurityException, Exception {
        if (this.getPrivateKey() == null) {
            throw new SecurityException("Account is encrypted and not usable!");
        }
        BIConnection bIConnection = null;
        XMLTransCert xMLTransCert = null;
        try {
            bIConnection = new BIConnection(this.m_theBI);
            bIConnection.connect();
            bIConnection.authenticate(this.m_accountCertificate, this.m_privateKey);
            xMLTransCert = bIConnection.charge(xMLGenericStrings);
            bIConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                bIConnection.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        this.m_transCerts.addElement(xMLTransCert);
        return xMLTransCert;
    }

    public void updated() {
        this.fireChangeEvent();
    }

    public String getPIID() {
        return this.m_strBiID;
    }

    public PaymentInstanceDBEntry getBI() {
        if (this.m_theBI == null) {
            this.m_theBI = PayAccountsFile.getInstance().getBI(this.m_strBiID);
        }
        return this.m_theBI;
    }

    public static String checkCouponCode(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken();
        }
        if (string.length() != 16) {
            return null;
        }
        string = string.toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9' || string.charAt(i) >= 'A' && string.charAt(i) <= 'F') continue;
            return null;
        }
        return string;
    }

    public void decryptPrivateKey(IMiscPasswordReader iMiscPasswordReader) throws Exception {
        if (this.m_encryptedPrivateKey != null) {
            this.decryptPrivateKey(this.m_encryptedPrivateKey, iMiscPasswordReader, false);
        }
    }

    private void decryptPrivateKey(Node node, final IMiscPasswordReader iMiscPasswordReader, boolean bl) throws Exception {
        Object object;
        if (this.m_privateKey != null || node == null) {
            return;
        }
        Element element = (Element)XMLUtil.getFirstChildByName(node, "EncryptedData");
        if (element != null) {
            try {
                if (bl) {
                    this.deactivate(element);
                    return;
                }
                object = iMiscPasswordReader != null ? new IMiscPasswordReader(){

                    public String readPassword(Object object) {
                        return iMiscPasswordReader.readPassword(new String("" + PayAccount.this.m_accountCertificate.getAccountNumber()));
                    }
                } : iMiscPasswordReader;
                LogHolder.log(7, LogType.PAY, "Decrypting account " + this.m_accountCertificate.getAccountNumber());
                XMLEncryption.decryptElement(element, (IMiscPasswordReader)object);
            }
            catch (Exception exception) {
                this.deactivate(element);
                return;
            }
        }
        object = (Element)XMLUtil.getFirstChildByName(node, "RSAPrivateKey");
        Element element2 = (Element)XMLUtil.getFirstChildByName(node, "DSAPrivateKey");
        if (object != null) {
            if (bl) {
                this.deactivate((Element)object);
                return;
            }
            this.m_privateKey = new MyRSAPrivateKey((Element)object);
        } else if (element2 != null) {
            if (bl) {
                this.deactivate(element2);
                return;
            }
            this.m_privateKey = new MyDSAPrivateKey(element2);
        } else {
            throw new XMLParseException("No RSA and no DSA private key found");
        }
        this.m_encryptedPrivateKey = null;
    }

    private void deactivate(Element element) throws Exception {
        this.m_privateKey = null;
        this.m_encryptedPrivateKey = XMLUtil.createDocument();
        this.m_encryptedPrivateKey.appendChild(XMLUtil.importNode(this.m_encryptedPrivateKey, element, true));
    }
}

