/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.crypto.IVerifyable;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.ServiceSoftware;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaymentInstanceDBEntry
extends AbstractDistributableCertifiedDatabaseEntry
implements IVerifyable {
    public static final String XML_ELEMENT_NAME = "PaymentInstance";
    public static final String XML_ELEMENT_CONTAINER_NAME = "PaymentInstances";
    private static final String XML_ELEM_NAME = "Name";
    private static final String XML_ELEM_CERT = "Certificate";
    private static final String XML_ELEM_NET = "Network";
    private String m_strPaymentInstanceId;
    private Element m_xmlDescription;
    private XMLSignature m_signature;
    private MultiCertPath m_certPath;
    private long m_creationTimeStamp;
    private long m_serialNumber;
    private Vector m_listenerInterfaces;
    private String m_name;
    private String m_strOrganisation;

    public PaymentInstanceDBEntry(Element element) throws XMLParseException {
        this(element, 0L);
    }

    public PaymentInstanceDBEntry(Element element, long l) throws XMLParseException {
        super(l == 0L ? System.currentTimeMillis() + 900000L : l);
        XMLUtil.assertNotNull(element);
        this.m_xmlDescription = element;
        String string = XMLUtil.parseValue(XMLUtil.getFirstChildByName(element, XML_ELEM_NAME), null);
        if (string == null) {
            throw new XMLParseException(XML_ELEM_NAME);
        }
        this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(element, 4);
        if (this.m_signature != null) {
            this.m_certPath = this.m_signature.getMultiCertPath();
            if (this.m_certPath != null) {
                this.m_strOrganisation = this.m_certPath.getSubject().getOrganisation();
            }
        }
        this.m_strPaymentInstanceId = element.getAttribute("id");
        if (!this.checkId()) {
            throw new XMLParseException(element.getNodeName(), "Invalid Payment-Instance ID: " + this.m_strPaymentInstanceId);
        }
        this.m_name = XMLUtil.parseValue(XMLUtil.getFirstChildByName(element, XML_ELEM_NAME), "");
        this.m_creationTimeStamp = XMLUtil.parseValue(XMLUtil.getFirstChildByName(element, "LastUpdate"), -1L);
        if (this.m_creationTimeStamp == -1L) {
            throw new XMLParseException("LastUpdate");
        }
        this.m_serialNumber = XMLUtil.parseAttribute((Node)element, "serial", this.m_creationTimeStamp);
        Node node = XMLUtil.getFirstChildByName(XMLUtil.getFirstChildByName(element, XML_ELEM_NET), "ListenerInterfaces");
        XMLUtil.assertNotNull(node);
        NodeList nodeList = ((Element)node).getElementsByTagName("ListenerInterface");
        if (nodeList.getLength() == 0) {
            throw new XMLParseException("ListenerInterface");
        }
        this.m_listenerInterfaces = new Vector();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.m_listenerInterfaces.addElement(new ListenerInterface((Element)nodeList.item(i)));
        }
    }

    public PaymentInstanceDBEntry(String string, String string2, JAPCertificate jAPCertificate, Enumeration enumeration, String string3, long l, long l2) {
        super(System.currentTimeMillis() + 900000L);
        Object object;
        this.m_strPaymentInstanceId = string;
        this.m_creationTimeStamp = l;
        this.m_serialNumber = l2;
        this.m_name = string2;
        Document document = XMLUtil.createDocument();
        Element element = document.createElement(XML_ELEMENT_NAME);
        document.appendChild(element);
        XMLUtil.setAttribute(element, "id", this.m_strPaymentInstanceId);
        XMLUtil.setAttribute(element, "serial", this.m_serialNumber);
        Element element2 = document.createElement(XML_ELEM_NAME);
        XMLUtil.setValue((Node)element2, this.m_name);
        element.appendChild(element2);
        ServiceSoftware serviceSoftware = new ServiceSoftware(string3);
        element.appendChild(serviceSoftware.toXmlElement(document));
        Element element3 = document.createElement(XML_ELEM_NET);
        element.appendChild(element3);
        Element element4 = document.createElement("ListenerInterfaces");
        element3.appendChild(element4);
        while (enumeration.hasMoreElements()) {
            object = (ListenerInterface)enumeration.nextElement();
            element4.appendChild(((ListenerInterface)object).toXmlElement(document));
        }
        object = document.createElement("LastUpdate");
        XMLUtil.setValue((Node)object, this.m_creationTimeStamp);
        element.appendChild((Node)object);
        if (jAPCertificate != null) {
            Element element5 = document.createElement(XML_ELEM_CERT);
            element.appendChild(element5);
            element5.appendChild(jAPCertificate.toXmlElement(document));
            this.m_signature = SignatureCreator.getInstance().getSignedXml(4, element);
            if (this.m_signature != null) {
                this.m_certPath = this.m_signature.getMultiCertPath();
            }
            if (this.m_certPath == null) {
                LogHolder.log(2, LogType.MISC, "Document could not be signed!");
            }
            this.m_strOrganisation = jAPCertificate.getSubject().getOrganisation();
        }
        this.m_xmlDescription = element;
    }

    public boolean isPersistanceDeletionAllowed() {
        return XMLUtil.getStorageMode() == 2;
    }

    public void deletePersistence() {
        if (this.isPersistanceDeletionAllowed()) {
            this.m_xmlDescription = null;
            this.m_signature = null;
        }
    }

    public boolean isVerified() {
        if (this.m_certPath != null) {
            return this.m_certPath.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public String toString() {
        return this.getName();
    }

    public String getOrganisation() {
        return this.m_strOrganisation;
    }

    public String getId() {
        return this.m_strPaymentInstanceId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaymentInstanceDBEntry) || object == null) {
            return false;
        }
        PaymentInstanceDBEntry paymentInstanceDBEntry = (PaymentInstanceDBEntry)object;
        return paymentInstanceDBEntry.getId() == this.getId() || paymentInstanceDBEntry.getId().equals(this.getId());
    }

    public int hashCode() {
        if (this.m_strPaymentInstanceId == null) {
            return 0;
        }
        return this.m_strPaymentInstanceId.hashCode();
    }

    public String getName() {
        return this.m_name;
    }

    public Enumeration getListenerInterfaces() {
        Random random = new Random();
        Vector vector = (Vector)this.m_listenerInterfaces.clone();
        Vector vector2 = new Vector();
        while (vector.size() > 0) {
            int n = Math.abs(random.nextInt() % vector.size());
            vector2.addElement(vector.elementAt(n));
            vector.removeElementAt(n);
        }
        return vector2.elements();
    }

    public long getVersionNumber() {
        return this.m_serialNumber;
    }

    public long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    public String getPostFile() {
        return "/paymentinstance";
    }

    public Element getXmlStructure() {
        return this.m_xmlDescription;
    }
}

